/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider;

import com.gargoylesoftware.htmlunit.WebClient;
import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.annotation.SimpleAction;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.flex.FlexSpiderFixture;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.spider.Finder;
import fitlibrary.spider.ForEachFixture;
import fitlibrary.spider.component.Alert;
import fitlibrary.spider.component.Frame;
import fitlibrary.spider.component.Page;
import fitlibrary.spider.component.SpiderWindow;
import fitlibrary.spider.component.TextInPage;
import fitlibrary.spider.driver.DriverVariation;
import fitlibrary.spider.driver.FirefoxVariation;
import fitlibrary.spider.driver.HtmlUnitVariation;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

@ShowSelectedActions
public class SpiderFixture
extends AbstractSpiderFixture {
    public static final String WEB_DRIVER_VARIABLE_NAME = "webDriver.driver";
    protected WebDriver webDriver = null;
    private SpiderWindow spiderWindow = new SpiderWindow(this);
    protected FirefoxProfile firefoxProfile = new FirefoxProfile();
    protected String proxyHost;
    protected int proxyPort;
    private boolean shutDownAutomatically = true;
    private Page page = new Page(this);
    private Frame frame = new Frame(this);
    private Alert alert = new Alert(this);
    private TextInPage textInPage = new TextInPage(this);

    public SpiderFixture() {
        this.setElementFinder(new WebDriverFinder());
        this.setSpiderFixture(this);
    }

    public SpiderWindow getWindow() {
        return this.spiderWindow;
    }

    public FlexSpiderFixture flex() {
        return new FlexSpiderFixture(this.webDriver());
    }

    @SimpleAction(wiki="|''<i>start spider with</i>''|browser name|", tooltip="Select the browser as one of htmlunit, firefox, or ie.")
    public boolean startSpiderWith(String theDriver) {
        this.setDynamicVariable(WEB_DRIVER_VARIABLE_NAME, theDriver);
        return true;
    }

    @SimpleAction(wiki="|''<i>use firefox profile</i>''|profile name|", tooltip="When running with firefox, select the profile to use.")
    public boolean useFirefoxProfile(String profileName) {
        this.firefoxProfile = new ProfilesIni().getProfile(profileName);
        if (this.firefoxProfile == null) {
            this.firefoxProfile = new FirefoxProfile();
            return false;
        }
        return true;
    }

    @SimpleAction(wiki="|''<i>use native events</i>''|boolean value|", tooltip="Switch native events mode on / off - currently only available in firefox.")
    public void useNativeEventsInFirefox(boolean enableNativeEvents) {
        this.firefoxProfile.setEnableNativeEvents(enableNativeEvents);
    }

    @SimpleAction(wiki="|''<i>firefox profile</i>''|key|''<i>as string</i>''|string value|", tooltip="Set the value of a string-based firefox profile key.")
    public void firefoxProfileAsString(String key, String value) {
        this.firefoxProfile.setPreference(key, value);
    }

    @SimpleAction(wiki="|''<i>firefox profile</i>''|key|''<i>as integer</i>''|integer value|", tooltip="Set the value of a integer-based firefox profile key.")
    public void firefoxProfileAsInteger(String key, int value) {
        this.firefoxProfile.setPreference(key, value);
    }

    @SimpleAction(wiki="|''<i>firefox profile</i>''|key|''<i>as boolean</i>''|boolean value|", tooltip="Set the value of a boolean-based firefox profile key.")
    public void firefoxProfileAsBoolean(String key, boolean value) {
        this.firefoxProfile.setPreference(key, value);
    }

    @SimpleAction(wiki="|''<i>proxy</i>''|host|''<i>with port</i>''|port number|", tooltip="Set the host and port of the proxy server to use.")
    public void proxyWithPort(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public void restart() throws Exception {
        this.tearDownDriver();
    }

    @SimpleAction(wiki="|''<i>restart with</i>''|browser|", tooltip="Start spider afresh on the current page with the same cookies, using the selected browser.\nThe browser is one of htmlunit, firefox, ie.")
    public void restartWith(String driver) {
        Set cookies = this.webDriver().manage().getCookies();
        String currentUrl = this.webDriver().getCurrentUrl();
        this.webDriver().close();
        this.webDriver = null;
        this.startSpiderWith(driver);
        this.webDriver().get(currentUrl);
        for (Cookie cookie : cookies) {
            this.webDriver().manage().addCookie(new Cookie(cookie.getName(), cookie.getValue()));
        }
    }

    @Override
    public WebDriver webDriver() {
        if (this.webDriver == null) {
            String driver = this.getDynamicVariable(WEB_DRIVER_VARIABLE_NAME, "htmlunit").toString();
            this.webDriver = "htmlunit".equals(driver) ? this.htmlUnitDriver() : ("firefox".equals(driver) ? this.fireFoxDriver() : ("ie".equals(driver) ? this.internetExplorerDriver() : ("chrome".equals(driver) ? this.chromeDriver() : this.unknownDriver(driver))));
            if (this.webDriver == null) {
                throw new FitLibraryException("Need to specify property 'webDriver.driver' as 'htmlunit', 'firefox', 'ie' or 'chrome'");
            }
            this.spiderWindow.setInitialWindow();
        }
        return this.webDriver;
    }

    protected Object getDynamicVariable(String key, String byDefault) {
        Object dynamicVariable = this.getDynamicVariable(key);
        if (dynamicVariable != null) {
            return dynamicVariable;
        }
        return byDefault;
    }

    @SimpleAction(wiki="|''<i>shut down browser automatically</i>''|true or false|", tooltip="When true, the browser shuts down automatically at the end of the storytest.\nTrue by default.\nMake this false is you want to view the browser after the storytest finishes.")
    public void shutdownBrowserAutomatically(boolean shutDownBrowserAutomatically) {
        this.shutDownAutomatically = shutDownBrowserAutomatically;
    }

    public void tearDown() throws Exception {
        this.tearDownDriver();
    }

    public void tearDownDriver() {
        if (this.shutDownAutomatically && this.webDriver != null) {
            this.webDriver.quit();
        }
        this.webDriver = null;
    }

    protected FirefoxDriver fireFoxDriver() {
        FirefoxDriver firefoxDriver = new FirefoxDriver(this.firefoxProfile);
        this.driverVariation = new FirefoxVariation(this, firefoxDriver);
        return firefoxDriver;
    }

    protected HtmlUnitDriver htmlUnitDriver() {
        class ExtendedHtmlUnitDriver
        extends HtmlUnitDriver {
            ExtendedHtmlUnitDriver() {
            }

            public WebClient getWebClient() {
                return super.getWebClient();
            }
        }
        ExtendedHtmlUnitDriver htmlUnitDriver = new ExtendedHtmlUnitDriver();
        if (this.proxyHost != null) {
            htmlUnitDriver.setProxy(this.proxyHost, this.proxyPort);
        }
        htmlUnitDriver.setJavascriptEnabled(true);
        this.driverVariation = new HtmlUnitVariation(this, htmlUnitDriver.getWebClient());
        return htmlUnitDriver;
    }

    protected InternetExplorerDriver internetExplorerDriver() {
        return new InternetExplorerDriver();
    }

    protected ChromeDriver chromeDriver() {
        return new ChromeDriver();
    }

    protected WebDriver unknownDriver(String driverName) {
        return null;
    }

    protected boolean isFirefox() {
        return this.webDriver instanceof FirefoxDriver;
    }

    public ForEachFixture forEachIn(String iteratorName, List<String> list) {
        return new ForEachFixture(iteratorName, list);
    }

    public void clearDriver() {
        this.webDriver = null;
        this.showAfterTable("Cleared driver");
    }

    public DriverVariation getDriverVariation() {
        return this.driverVariation;
    }

    public Page getPage() {
        return this.page;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public TextInPage getTextInPage() {
        return this.textInPage;
    }

    public int getTimeout(String name) {
        return super.getTimeout(name);
    }

    class WebDriverFinder
    implements Finder {
        WebDriverFinder() {
        }

        @Override
        public WebElement findElement(String locator) {
            if (locator.startsWith("id=")) {
                return this.findElement(By.id((String)locator.substring(3)));
            }
            if (locator.startsWith("xpath=")) {
                return this.findElement(By.xpath((String)locator.substring(6)));
            }
            if (locator.startsWith("link=")) {
                return this.findElement(By.linkText((String)locator.substring(5)));
            }
            if (locator.startsWith("name=")) {
                return this.findElement(By.name((String)locator.substring(5)));
            }
            if (locator.startsWith("css=")) {
                return this.findElement(By.cssSelector((String)locator.substring(4)));
            }
            if (locator.startsWith("class=")) {
                return this.findElement(By.className((String)locator.substring(6)));
            }
            if (locator.startsWith("//") || locator.startsWith("(//")) {
                return this.findElement(By.xpath((String)locator));
            }
            return this.findElement(By.id((String)locator));
        }

        @Override
        public WebElement findElement(By by) {
            return SpiderFixture.this.webDriver().findElement(by);
        }

        @Override
        public List<WebElement> findElements(String locator) {
            return SpiderFixture.this.webDriver().findElements(By.xpath((String)locator));
        }

        @Override
        public WebElement findOption(String locator, String option, AbstractSpiderFixture abstractSpiderFixture) {
            return abstractSpiderFixture.findElement(String.valueOf(locator) + "/option[@value ='" + option.toUpperCase() + "']");
        }
    }
}

