/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.component;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.runResults.TestResults;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.component.SpiderComponent;
import fitlibrary.spider.polling.PollForWithError;
import fitlibrary.spider.utility.Diagnostics;
import fitlibrary.spider.utility.HtmlTextUtility;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;

public class Page
extends SpiderComponent {
    public static final String POLL_URL_TIMEOUT = "pollUrl";
    private final Diagnostics diagnostics;

    public Page(SpiderFixture spiderFixture) {
        super(spiderFixture);
        this.diagnostics = new Diagnostics(spiderFixture);
    }

    public boolean getUrl(String url) throws Exception {
        this.checkUnbound(url);
        try {
            this.webDriver().get(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.problem(e.toString(), url);
        }
        this.driverVariation().checkTitleOfNewPage(url);
        return true;
    }

    private void checkUnbound(String s) {
        int at = s.indexOf("@{");
        if (at < 0) {
            return;
        }
        if (s.indexOf("}", at) > 0) {
            throw new FitLibraryException("Unbound variable");
        }
    }

    public boolean back() {
        this.webDriver().navigate().back();
        return true;
    }

    public boolean forward() {
        this.webDriver().navigate().forward();
        return true;
    }

    public boolean refresh() {
        this.webDriver().navigate().refresh();
        return true;
    }

    public String getTitle() {
        try {
            String title = this.webDriver().getTitle();
            title = HtmlTextUtility.spacesToSingleSpace(HtmlTextUtility.nonBreakingSpaceToSpace(title));
            this.diagnostics.checkForShow();
            return title;
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String getUrl() {
        try {
            return this.fixFileUrlProblem(this.shortUrl());
        }
        catch (NullPointerException e) {
            throw new FitLibraryException("Unavailable");
        }
    }

    public void pollUrl(final Row row, final TestResults testResults) throws Exception {
        final String url = row.text(1, (VariableResolver)this.spiderFixture);
        final ICalledMethodTarget target = this.spiderFixture.findMethodFromRow(row, 3, 0);
        this.ensureWithError(new PollForWithError(){

            @Override
            public String error() {
                return "Condition not satisfied";
            }

            @Override
            public boolean matches() {
                try {
                    Page.this.webDriver().get(url);
                    Object result = target.invokeForSpecial((Row)row.fromAt(4), testResults, true, (Cell)row.at(0));
                    if (result instanceof Boolean) {
                        return (Boolean)result;
                    }
                }
                catch (Exception e) {
                    throw new FitLibraryException(e.getMessage());
                }
                throw new FitLibraryException("Can only use an action that returns a boolean");
            }
        }, POLL_URL_TIMEOUT);
        ((Cell)row.at(1)).pass(testResults);
    }

    public void showErrorDiagnosticsAtWhenPageContains(String xpath, String pattern) {
        this.diagnostics.setUp(xpath, pattern);
    }

    public void checkForError() {
        this.diagnostics.checkForShow();
    }

    private String shortUrl() {
        String url = "";
        try {
            url = this.webDriver().getCurrentUrl();
            int pos = url.indexOf(";");
            if (pos >= 0) {
                return " at " + url.substring(0, pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private String fixFileUrlProblem(String currentUrl) {
        if (currentUrl.startsWith("file:/")) {
            return "file:///" + currentUrl.substring(6);
        }
        return currentUrl;
    }
}

