/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.driver;

import fitlibrary.differences.LocalFile;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.traverse.Traverse;
import java.util.Random;

public class DriverVariation {
    protected static Random RANDOM = new Random(System.currentTimeMillis());
    protected final AbstractSpiderFixture spiderFixture;
    private String screenDumpDirectoryName = "images";

    public DriverVariation(AbstractSpiderFixture spiderFixture) {
        this.spiderFixture = spiderFixture;
    }

    public boolean close() {
        this.spiderFixture.webDriver().close();
        return true;
    }

    public void checkTitleOfNewPage(String url) throws Exception {
        if (this.spiderFixture.getTitle() == null) {
            throw this.spiderFixture.problem("Unable to access", url);
        }
    }

    public void screenDump() {
        this.spiderFixture.showAfterTable(this.spiderFixture.pageSource());
    }

    protected LocalFile pngFile() {
        return this.pngFile("screenDump" + RANDOM.nextInt());
    }

    protected LocalFile pngFile(String fileName) {
        LocalFile globalFile = Traverse.getGlobalFile((String)(String.valueOf(this.screenDumpDirectoryName) + "/" + fileName + ".png"));
        globalFile.mkdirs();
        return globalFile;
    }

    public void screenDump(String fileName) {
        this.screenDump();
    }

    public void setScreenDumpDirectory(String diryName) {
        this.screenDumpDirectoryName = diryName;
    }
}

