/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.element;

import fit.Parse;
import fitlibrary.spider.AbstractSpiderFixture;
import fitlibrary.spider.MultiLineMatchFixture;
import fitlibrary.spider.element.SpiderElement;
import fitlibrary.spider.polling.PollForWithError;
import fitlibrary.spider.utility.HtmlTextUtility;
import fitlibrary.spider.utility.StringUtility;
import org.openqa.selenium.WebElement;

public class TextElement
extends SpiderElement {
    public TextElement(AbstractSpiderFixture spiderFixture) {
        super(spiderFixture);
    }

    public String textOf(String locator) {
        return this.collectText(this.findElement(locator));
    }

    public String plainTextOf(String locator) {
        return HtmlTextUtility.tagless(this.collectText(this.findElement(locator), true));
    }

    public String innerHtmlOf(String locator) {
        WebElement element = this.findElement(locator);
        Object escaped = this.spiderFixture().executeJavaScriptWith("return arguments[0].innerHTML;", element);
        return HtmlTextUtility.lowerCaseTags(Parse.unescape((String)escaped.toString()));
    }

    public String textOfElementOnly(String locator) {
        return HtmlTextUtility.removeInnerHtml(this.innerHtmlOf(locator));
    }

    public MultiLineMatchFixture textOfMatchesLines(String locator) {
        String text = this.collectText(this.findElement(locator), false);
        return new MultiLineMatchFixture(this.collectTaglessLines(text));
    }

    private Object[] collectTaglessLines(String lines) {
        if ("".equals(lines)) {
            return new Object[0];
        }
        return lines.split("\n");
    }

    public boolean optionallyWithSetText(String locator, String s) {
        if (s.equals("") || s.contains("@{")) {
            return true;
        }
        try {
            this.withSetText(locator, s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean withSetText(final String locator, final String s) {
        final WebElement element = this.findElement(locator);
        if (!element.isEnabled()) {
            return true;
        }
        element.clear();
        element.sendKeys(new CharSequence[]{TextElement.whiteSpace(s)});
        this.ensureBecomes(new PollForWithError(){

            @Override
            public boolean matches() {
                return TextElement.this.textOf(locator).equals(TextElement.NLandTABasSpace(s));
            }

            @Override
            public String error() {
                return "Text wasn't changed correctly, it's " + (element.getText().length() > 0 ? "'" + element.getText() + "'" : "empty");
            }
        });
        return true;
    }

    public boolean withAddText(final String locator, final String s) {
        final WebElement element = this.findElement(locator);
        if (!element.isEnabled()) {
            return true;
        }
        element.sendKeys(new CharSequence[]{TextElement.whiteSpace(s)});
        this.ensureBecomes(new PollForWithError(){

            @Override
            public boolean matches() {
                return TextElement.this.textOf(locator).endsWith(TextElement.whiteSpace(s));
            }

            @Override
            public String error() {
                return "Text wasn't changed correctly, it's '" + element.getText() + "'";
            }
        });
        return true;
    }

    public String collectText(WebElement element) {
        return this.collectText(element, true);
    }

    private String collectText(WebElement element, boolean trim) {
        String value;
        block5: {
            value = element.getText();
            if (value == null || "".equals(value.trim())) {
                try {
                    value = element.getAttribute("value");
                }
                catch (UnsupportedOperationException uso) {
                    if (uso.getMessage().contains("Element does not have a value attribute")) break block5;
                    throw uso;
                }
            }
        }
        if (value == null) {
            value = "";
        }
        if (trim) {
            value = TextElement.spacesToSingleSpace(TextElement.crLfToSpace(HtmlTextUtility.nonBreakingSpaceToSpace(TextElement.tabToSpace(HtmlTextUtility.brToSpace(value))))).trim();
        }
        return Parse.unescape((String)value);
    }

    protected static String whiteSpace(String s) {
        return StringUtility.replaceAll(s, "\\n", "\n").replaceAll("\\t", "\t");
    }

    protected static String NLandTABasSpace(String s) {
        return StringUtility.replaceAll(s, "\\n", " ").replaceAll("\\t", " ");
    }

    public static String crLfToSpace(String s) {
        return s.replaceAll("\\r?\\n", " ");
    }

    public static String spacesToSingleSpace(String s) {
        return s.replaceAll("\\s{2,}", " ");
    }

    public static String tabToSpace(String s) {
        return s.replaceAll("\\t", " ");
    }
}

