/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.polling;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.FixturingLogger;
import fitlibrary.spider.polling.PollForMatches;
import fitlibrary.spider.polling.PollForNoException;
import fitlibrary.spider.polling.PollForWithError;
import org.apache.log4j.Logger;

public class Poll {
    static Logger logger = FixturingLogger.getLogger(Poll.class);
    protected static final long MIN_SLEEP = 2L;
    protected static final long MAX_SLEEP = 10L;
    protected static final long DIV_SLEEP = 50L;
    private final long timeout;
    private final long start = Poll.now();

    public Poll(long timeout) {
        this.timeout = timeout;
    }

    public void ensureWithError(PollForWithError poll) {
        while (!this.timedOut()) {
            if (poll.matches()) {
                return;
            }
            Poll.sleep(this.timeout);
        }
        throw new FitLibraryException(poll.error());
    }

    public boolean ensureMatches(PollForMatches poll) {
        while (!this.timedOut()) {
            if (poll.matches()) {
                return true;
            }
            Poll.sleep(this.timeout);
        }
        this.timeOutTrace();
        return false;
    }

    public boolean ensureMatchesNoException(PollForMatches poll) {
        while (!this.timedOut()) {
            try {
                if (poll.matches()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Poll.sleep(this.timeout);
        }
        this.timeOutTrace();
        return false;
    }

    public <T> T ensureNoException(PollForNoException<T> poll) throws Exception {
        boolean loggedError = false;
        while (true) {
            try {
                return poll.act();
            }
            catch (Exception e) {
                if (!loggedError) {
                    logger.trace((Object)("Exception caught: " + e));
                }
                loggedError = true;
                if (this.timedOut()) {
                    throw e;
                }
                Poll.sleep(this.timeout);
                continue;
            }
            break;
        }
    }

    private boolean timedOut() {
        return Poll.now() - this.start > this.timeout;
    }

    private static void sleep(long timeout) {
        try {
            Thread.sleep(Poll.sleepPeriod(timeout));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static long sleepPeriod(long timeout) {
        return Math.min(10L, Math.max(2L, timeout / 50L));
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private void timeOutTrace() {
        logger.trace((Object)("Timed out after " + (Poll.now() - this.start) + " milliseconds"));
    }
}

