/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.template;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.traverse.workflow.DoTraverse;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class TemplateFixture
extends DoTraverse {
    public String getTemplate(String fileName) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.processTemplate(fileName, stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public void getTemplateAsFile(String fileName, String outFileName) throws Exception {
        FileWriter fileWriter = new FileWriter(new File(outFileName));
        this.processTemplate(fileName, fileWriter);
        fileWriter.close();
    }

    private void processTemplate(String fileName, Writer writer) throws Exception {
        Template template = Velocity.getTemplate((String)fileName);
        VelocityContext context = new VelocityContext(this.getDynamicVariables().getMap());
        template.merge((Context)context, writer);
    }
}

