/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.mock.requestMatcher;

import fitlibrary.mockWebServices.requestMatcher.OrRequestMatcher;
import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.ws.message.Message;
import fitlibrary.ws.message.ReplyMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestOrRequestMatcher {
    Mockery context = new JUnit4Mockery();
    final RequestMatcher first = (RequestMatcher)this.context.mock(RequestMatcher.class, "first");
    final RequestMatcher second = (RequestMatcher)this.context.mock(RequestMatcher.class, "second");
    private RequestMatcher matcher = new OrRequestMatcher(this.first, this.second);
    protected final Message request = TestOrRequestMatcher.msg("any string");

    @Test
    public void matchTrueAnything() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestOrRequestMatcher.this.first)).match(TestOrRequestMatcher.this.request);
                this.will(1.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.matcher.match(TestOrRequestMatcher.msg("any string")), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void matchFalseTrue() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestOrRequestMatcher.this.first)).match(TestOrRequestMatcher.this.request);
                this.will(2.returnValue((Object)false));
                ((RequestMatcher)this.one(TestOrRequestMatcher.this.second)).match(TestOrRequestMatcher.this.request);
                this.will(2.returnValue((Object)true));
            }
        });
        Assert.assertThat((Object)this.matcher.match(TestOrRequestMatcher.msg("any string")), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void matchFalseFalse() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RequestMatcher)this.one(TestOrRequestMatcher.this.first)).match(TestOrRequestMatcher.this.request);
                this.will(3.returnValue((Object)false));
                ((RequestMatcher)this.one(TestOrRequestMatcher.this.second)).match(TestOrRequestMatcher.this.request);
                this.will(3.returnValue((Object)false));
            }
        });
        Assert.assertThat((Object)this.matcher.match(this.request), (Matcher)Matchers.equalTo((Object)false));
    }

    private static ReplyMessage msg(String string) {
        return new ReplyMessage(string);
    }
}

