/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ws.recorder;

import fitlibrary.log.FixturingLogger;
import fitlibrary.server.Recorder;
import fitlibrary.ws.recorder.RecordingFolderSelector;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FileRecorder
implements Recorder {
    static Logger logger = FixturingLogger.getLogger(FileRecorder.class);
    private static final String REQUEST_FILENAME = "request.xml";
    private static final String RESPONSE_FILENAME = "response.xml";
    private final int localPortNo;
    private final File resultsFolder;
    private final AtomicInteger count = new AtomicInteger(0);
    private final String soapVersion;

    public FileRecorder(int localPortNo, String resultsFolderName, String soapVersion, RecordingFolderSelector recordingFolderSelector) {
        this.localPortNo = localPortNo;
        this.soapVersion = soapVersion;
        File folder = new File(resultsFolderName);
        this.resultsFolder = new File(folder, recordingFolderSelector.selectFileName());
        this.resultsFolder.mkdirs();
    }

    @Override
    public void record(String uri, String requestContents, String responseContents) {
        String fileName = "Port" + this.localPortNo + "Response" + this.count.incrementAndGet();
        File diry = new File(this.resultsFolder, fileName);
        diry.mkdirs();
        this.writeFile(diry, REQUEST_FILENAME, requestContents);
        this.writeFile(diry, RESPONSE_FILENAME, responseContents);
        StringBuilder s = new StringBuilder();
        if (this.count.get() == 1) {
            s.append("!*> diry\n!define diry (!-" + this.resultsFolder.getAbsolutePath() + "-!)\n" + "*!\n\n" + "|'''also run'''|''with mock web services''|\n\n" + "|''mock full soap as''|" + this.soapVersion + "|''on port''|" + this.localPortNo + "|\n");
        } else {
            s.append("|''then''|\n");
        }
        s.append("|''matches URL''|!-" + uri + "-!|\n" + "|''matches request from file''|${diry}/!-" + fileName + "/" + REQUEST_FILENAME + "-!|\n" + "|''response from file''|${diry}/!-" + fileName + "/" + RESPONSE_FILENAME + "-!|\n");
        this.writeFile(this.resultsFolder, "storytest" + this.localPortNo + ".txt", s.toString());
    }

    private void writeFile(File diry, String fileName, String msg) {
        File requestFile = new File(diry, fileName);
        try {
            FileWriter fileWriter = new FileWriter(requestFile);
            IOUtils.write((String)msg, (Writer)fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)("Problem writing file: " + e));
        }
    }
}

