/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.xml;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.global.PlugBoard;
import fitlibrary.traverse.workflow.DoTraverse;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndTextQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.Transform;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XmlDoFixture
extends DoTraverse {
    protected Map<String, String> nameSpaceMap = new HashMap<String, String>();

    static {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
    }

    public XmlDoFixture() {
        this.nameSpace("");
    }

    public void nameSpace(String prefix) {
        this.nameSpacePrefixUri(prefix, "urn:" + prefix);
    }

    public void nameSpacePrefixUri(String prefix, String namespaceUrn) {
        this.nameSpaceMap.put(prefix, namespaceUrn);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(this.nameSpaceMap));
    }

    public boolean xmlSameAs(String actualXml, String expectedXml) {
        Diff diff = XmlDoFixture.diff(actualXml, expectedXml);
        if (diff.identical()) {
            return true;
        }
        return XmlDoFixture.mismatch(diff);
    }

    public boolean xmlSimilarTo(String actualXml, String expectedXml) {
        Diff diff = XmlDoFixture.diff(actualXml, expectedXml);
        diff.overrideElementQualifier((ElementQualifier)new ElementNameAndTextQualifier());
        if (diff.similar()) {
            return true;
        }
        return XmlDoFixture.mismatch(diff);
    }

    public boolean xpathExistsIn(String xPathExpression, String xml) {
        try {
            NodeList nodeList = this.xpathEngine().getMatchingNodes(xPathExpression, XmlDoFixture.doc(xml));
            return nodeList.getLength() > 0;
        }
        catch (XpathException e) {
            throw new FitLibraryException("invalid xpath");
        }
    }

    public String xpathIn(String xPathExpression, String xml) {
        try {
            return this.xpathEngine().evaluate(xPathExpression, XmlDoFixture.doc(xml));
        }
        catch (XpathException e) {
            throw new FitLibraryException("invalid xpath");
        }
    }

    public String transformWith(String xml, String xslt) {
        try {
            Transform transform = new Transform(xml, xslt);
            transform.setOutputProperty("omit-xml-declaration", "yes");
            return transform.getResultString();
        }
        catch (TransformerException e) {
            throw this.xmlError(e);
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public String transformWithFile(String xml, String fileName) {
        try {
            Transform transform = new Transform(xml, new File(fileName));
            transform.setOutputProperty("omit-xml-declaration", "yes");
            return transform.getResultString();
        }
        catch (TransformerException e) {
            throw this.xmlError(e);
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    public static Diff diff(String actualXml, String expectedXml) {
        return XmlDoFixture.diff(XmlDoFixture.doc(actualXml), XmlDoFixture.doc(expectedXml));
    }

    private static Document doc(String xml) {
        try {
            return XMLUnit.buildControlDocument((String)XmlDoFixture.removeEmptyNameSpace(xml));
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    private static String removeEmptyNameSpace(String xmlInitial) {
        String xml = xmlInitial;
        xml = XmlDoFixture.removeEmptyNameSpace(xml, "'");
        return XmlDoFixture.removeEmptyNameSpace(xml, "\"");
    }

    private static String removeEmptyNameSpace(String xmlInitial, String quote) {
        String xml = xmlInitial;
        int start;
        while ((start = xml.indexOf(" xmlns=" + quote)) >= 0) {
            if (start < 0) continue;
            int end = xml.indexOf(quote, start + " xmlns=".length() + 1);
            if (end < 0) {
                return xml;
            }
            xml = String.valueOf(xml.substring(0, start)) + xml.substring(end + 1);
        }
        return xml;
    }

    private XpathEngine xpathEngine() {
        XpathEngine engine = XMLUnit.newXpathEngine();
        engine.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(this.nameSpaceMap));
        return engine;
    }

    private static Diff diff(Document actualXml, Document expectedXml) {
        try {
            return new Diff(expectedXml, actualXml);
        }
        catch (Exception e) {
            throw new FitLibraryException(e.getMessage());
        }
    }

    private static boolean mismatch(Diff diff) {
        String DIFFERENT = "[different] ";
        String difference = new DetailedDiff(diff).toString();
        int at = difference.indexOf("[different] ");
        if (at >= 0) {
            difference = difference.substring(at + "[different] ".length());
        }
        difference = difference.replaceAll("\n\\[different\\] ", "<hr>");
        throw new FitLibraryException(difference.trim());
    }

    private FitLibraryException xmlError(TransformerException e) {
        String ERROR_MSG = "XML document structures must start and end within the same entity.";
        String message = PlugBoard.exceptionHandling.unwrapThrowable((Throwable)e).getMessage().trim();
        if (message.endsWith("XML document structures must start and end within the same entity.")) {
            return new FitLibraryException("XML document structures must start and end within the same entity.");
        }
        return new FitLibraryException(message);
    }
}

