/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.ComponentFactory;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.WikiPage;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;
import util.DiskFileSystem;
import util.FileSystem;

public class WikiPageFactory {
    private Class<?> wikiPageClass = FileSystemPage.class;
    private FileSystem fileSystem;

    public WikiPageFactory() {
        this(new DiskFileSystem());
    }

    public WikiPageFactory(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public WikiPage makeRootPage(String rootPath, String rootPageName, ComponentFactory componentFactory) throws Exception {
        try {
            Constructor<?> constructorMethod = this.wikiPageClass.getConstructor(String.class, String.class, FileSystem.class, ComponentFactory.class);
            return (WikiPage)constructorMethod.newInstance(rootPath, rootPageName, this.fileSystem, componentFactory);
        }
        catch (NoSuchMethodException e) {
            Method makeRootMethod = this.wikiPageClass.getMethod("makeRoot", Properties.class);
            return (WikiPage)makeRootMethod.invoke(this.wikiPageClass, componentFactory.getProperties());
        }
    }

    public Class<?> getWikiPageClass() {
        return this.wikiPageClass;
    }

    public void setWikiPageClass(Class<?> wikiPageClass) {
        this.wikiPageClass = wikiPageClass;
    }
}

