/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;

public class HtmlPage
extends HtmlTag {
    public static final String DTD = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    public static final String BreakPoint = "<!--BREAKPOINT-->";
    public HtmlTag head;
    public HtmlTag title;
    public HtmlTag body;
    public HtmlTag header;
    public HtmlTag sidebar;
    public HtmlTag mainbar;
    public HtmlTag artNiche;
    public HtmlTag actions;
    public HtmlTag main;
    public String preDivision;
    public String postDivision;

    protected HtmlPage() {
        super("html");
        this.add(this.makeHead());
        this.add(this.makeBody());
    }

    @Override
    public String html() {
        return DTD + endl + super.html();
    }

    protected HtmlTag makeBody() {
        this.body = new HtmlTag("body");
        this.mainbar = HtmlUtil.makeDivTag("mainbar");
        this.header = HtmlUtil.makeDivTag("header");
        this.sidebar = HtmlUtil.makeDivTag("sidebar");
        this.actions = HtmlUtil.makeDivTag("actions");
        this.main = HtmlUtil.makeDivTag("main");
        this.makeArtNiche();
        this.mainbar.add(this.header);
        this.mainbar.add(this.main);
        this.sidebar.add(this.artNiche);
        this.sidebar.add(this.actions);
        this.body.add(this.sidebar);
        this.body.add(this.mainbar);
        return this.body;
    }

    protected void makeArtNiche() {
        this.artNiche = HtmlUtil.makeDivTag("art_niche");
        this.artNiche.addAttribute("onclick", "document.location='FrontPage'");
    }

    protected HtmlTag makeHead() {
        this.head = new HtmlTag("head");
        this.title = new HtmlTag("title");
        this.title.add("FitNesse");
        this.head.add(this.title);
        this.head.add(this.makeCssLink("/files/css/fitnesse.css", "screen"));
        this.head.add(this.makeCssLink("/files/css/fitnesse_print.css", "print"));
        this.head.add(HtmlUtil.makeJavascriptLink("/files/javascript/fitnesse.js"));
        return this.head;
    }

    public HtmlTag makeCssLink(String link, String media) {
        HtmlTag css = new HtmlTag("link");
        css.addAttribute("rel", "stylesheet");
        css.addAttribute("type", "text/css");
        css.addAttribute("href", link);
        css.addAttribute("media", media);
        return css;
    }

    public void divide() throws Exception {
        String html = this.html();
        int breakIndex = html.indexOf(BreakPoint);
        this.preDivision = html.substring(0, breakIndex);
        this.postDivision = html.substring(breakIndex + BreakPoint.length());
    }
}

