/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PageListSetUpTearDownSurrounder {
    private WikiPage root;
    private List<WikiPage> pageList;

    public PageListSetUpTearDownSurrounder(WikiPage root) {
        this.root = root;
    }

    public void surroundGroupsOfTestPagesWithRespectiveSetUpAndTearDowns(List<WikiPage> pageList) throws Exception {
        this.pageList = pageList;
        HashMap<String, LinkedList<WikiPage>> pageSetUpTearDownGroups = new HashMap<String, LinkedList<WikiPage>>();
        this.createPageSetUpTearDownGroups(pageSetUpTearDownGroups);
        pageList.clear();
        this.reinsertPagesViaSetUpTearDownGroups(pageSetUpTearDownGroups);
    }

    private void createPageSetUpTearDownGroups(Map<String, LinkedList<WikiPage>> pageSetUpTearDownGroups) throws Exception {
        for (WikiPage page : this.pageList) {
            this.makeSetUpTearDownPageGroupForPage(page, pageSetUpTearDownGroups);
        }
    }

    private void makeSetUpTearDownPageGroupForPage(WikiPage page, Map<String, LinkedList<WikiPage>> pageSetUpTearDownGroups) throws Exception {
        String group = this.getSetUpTearDownGroup(page);
        if (pageSetUpTearDownGroups.get(group) != null) {
            LinkedList<WikiPage> pageGroup = pageSetUpTearDownGroups.get(group);
            pageGroup.add(page);
        } else {
            LinkedList<WikiPage> pageGroup = new LinkedList<WikiPage>();
            pageGroup.add(page);
            pageSetUpTearDownGroups.put(group, pageGroup);
        }
    }

    private String getSetUpTearDownGroup(WikiPage page) throws Exception {
        String setUpPath = this.getPathForSetUpTearDown(page, "SuiteSetUp");
        String tearDownPath = this.getPathForSetUpTearDown(page, "SuiteTearDown");
        return setUpPath + "," + tearDownPath;
    }

    private String getPathForSetUpTearDown(WikiPage page, String setUpTearDownName) throws Exception {
        String path = null;
        WikiPage suiteSetUpTearDown = PageCrawlerImpl.getClosestInheritedPage(setUpTearDownName, page);
        if (suiteSetUpTearDown != null) {
            path = suiteSetUpTearDown.getPageCrawler().getFullPath(suiteSetUpTearDown).toString();
        }
        return path;
    }

    private void reinsertPagesViaSetUpTearDownGroups(Map<String, LinkedList<WikiPage>> pageSetUpTearDownGroups) throws Exception {
        Set<String> groups = pageSetUpTearDownGroups.keySet();
        for (String group : groups) {
            String setUpAndTearDownGroupKey = group.toString();
            LinkedList<WikiPage> pageGroup = pageSetUpTearDownGroups.get(group);
            this.insertSetUpTearDownPageGroup(setUpAndTearDownGroupKey, pageGroup);
        }
    }

    private void insertSetUpTearDownPageGroup(String setUpAndTearDownGroupKey, LinkedList<WikiPage> pageGroup) throws Exception {
        this.insertSetUpForThisGroup(setUpAndTearDownGroupKey);
        this.insertPagesOfThisGroup(pageGroup);
        this.insertTearDownForThisGroup(setUpAndTearDownGroupKey);
    }

    private void insertSetUpForThisGroup(String setUpAndTearDown) throws Exception {
        String setUpPath = setUpAndTearDown.split(",")[0];
        WikiPage setUpPage = this.root.getPageCrawler().getPage(this.root, PathParser.parse(setUpPath));
        if (setUpPage != null) {
            this.pageList.add(setUpPage);
        }
    }

    private void insertPagesOfThisGroup(LinkedList<WikiPage> pageGroup) {
        for (WikiPage page : pageGroup) {
            this.pageList.add(page);
        }
    }

    private void insertTearDownForThisGroup(String setUpAndTearDownGroupKey) throws Exception {
        String tearDownPath = setUpAndTearDownGroupKey.split(",")[1];
        WikiPage tearDownPage = this.root.getPageCrawler().getPage(this.root, PathParser.parse(tearDownPath));
        if (tearDownPage != null) {
            this.pageList.add(tearDownPage);
        }
    }
}

