/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.slimResponder;

import fitnesse.components.CommandRunner;
import fitnesse.responders.run.ExecutionLog;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.responders.run.slimResponder.ExceptionList;
import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slim.SlimClient;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimService;
import fitnesse.slimTables.ScenarioTable;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.SlimTableFactory;
import fitnesse.slimTables.Table;
import fitnesse.slimTables.TableScanner;
import fitnesse.testutil.MockCommandRunner;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Symbol;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SlimTestSystem
extends TestSystem
implements SlimTestContext {
    public static final String MESSAGE_ERROR = "!error:";
    public static final String MESSAGE_FAIL = "!fail:";
    public static final SlimTable START_OF_TEST = null;
    public static final SlimTable END_OF_TEST = null;
    private CommandRunner slimRunner;
    private String slimCommand;
    private SlimClient slimClient;
    protected Map<String, Object> allInstructionResults = new HashMap<String, Object>();
    protected List<SlimTable> allTables = new ArrayList<SlimTable>();
    protected List<Object> allInstructions = new ArrayList<Object>();
    protected List<SlimTable.Expectation> allExpectations = new ArrayList<SlimTable.Expectation>();
    protected List<Object> instructions;
    private boolean started;
    protected PageData testResults;
    protected TableScanner tableScanner;
    protected Map<String, Object> instructionResults;
    protected List<SlimTable> testTables = new ArrayList<SlimTable>();
    protected ExceptionList exceptions = new ExceptionList();
    private Map<String, String> symbols = new HashMap<String, String>();
    protected TestSummary testSummary;
    private static AtomicInteger slimSocketOffset = new AtomicInteger(0);
    private int slimSocket;
    protected final Pattern exceptionMessagePattern = Pattern.compile("message:<<(.*)>>");
    private Map<String, ScenarioTable> scenarios = new HashMap<String, ScenarioTable>();
    protected List<SlimTable.Expectation> expectations = new ArrayList<SlimTable.Expectation>();
    private SlimTableFactory slimTableFactory = new SlimTableFactory();
    private Symbol preparsedScenarioLibrary;

    public SlimTestSystem(WikiPage page, TestSystemListener listener) {
        super(page, listener);
        this.testSummary = new TestSummary(0, 0, 0, 0);
    }

    @Override
    public String getSymbol(String symbolName) {
        return this.symbols.get(symbolName);
    }

    @Override
    public void setSymbol(String symbolName, String value) {
        this.symbols.put(symbolName, value);
    }

    @Override
    public void addScenario(String scenarioName, ScenarioTable scenarioTable) {
        this.scenarios.put(scenarioName, scenarioTable);
    }

    @Override
    public ScenarioTable getScenario(String scenarioName) {
        return this.scenarios.get(scenarioName);
    }

    @Override
    public void addExpectation(SlimTable.Expectation e) {
        this.expectations.add(e);
    }

    @Override
    public boolean isSuccessfullyStarted() {
        return this.started;
    }

    @Override
    public void kill() throws Exception {
        if (this.slimRunner != null) {
            this.slimRunner.kill();
        }
        if (this.slimClient != null) {
            this.slimClient.close();
        }
    }

    String getSlimFlags() throws Exception {
        String slimFlags = this.page.getData().getVariable("SLIM_FLAGS");
        if (slimFlags == null) {
            slimFlags = "";
        }
        return slimFlags;
    }

    @Override
    protected ExecutionLog createExecutionLog(String classPath, TestSystem.Descriptor descriptor) throws Exception {
        String slimFlags = this.getSlimFlags();
        this.slimSocket = this.getNextSlimSocket();
        String slimArguments = String.format("%s %d", slimFlags, this.slimSocket);
        String slimCommandPrefix = this.buildCommand(descriptor, classPath);
        this.slimCommand = String.format("%s %s", slimCommandPrefix, slimArguments);
        if (this.fastTest) {
            this.slimRunner = new MockCommandRunner();
            this.createSlimService(slimArguments);
        }
        if (this.manualStart) {
            this.slimSocket = this.getSlimPortBase();
            this.slimRunner = new MockCommandRunner();
        } else {
            this.slimRunner = new CommandRunner(this.slimCommand, "", this.createClasspathEnvironment(classPath));
        }
        return new ExecutionLog(this.page, this.slimRunner);
    }

    public int findFreePort() {
        int port;
        try {
            ServerSocket socket = new ServerSocket(0);
            port = socket.getLocalPort();
            socket.close();
        }
        catch (Exception e) {
            port = -1;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextSlimSocket() {
        int base = this.getSlimPortBase();
        if (base == 0) {
            return this.findFreePort();
        }
        AtomicInteger atomicInteger = slimSocketOffset;
        synchronized (atomicInteger) {
            int offset = slimSocketOffset.get();
            offset = (offset + 1) % 10;
            slimSocketOffset.set(offset);
            return offset + base;
        }
    }

    private int getSlimPortBase() {
        int base = 8085;
        try {
            String slimPort = this.page.getData().getVariable("SLIM_PORT");
            if (slimPort != null) {
                int slimPortInt;
                base = slimPortInt = Integer.parseInt(slimPort);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return base;
    }

    @Override
    public void start() throws Exception {
        this.slimRunner.asynchronousStart();
        this.slimClient = new SlimClient(this.determineSlimHost(), this.slimSocket);
        try {
            this.waitForConnection();
            this.started = true;
        }
        catch (SlimError e) {
            this.testSystemListener.exceptionOccurred(e);
        }
    }

    String determineSlimHost() throws Exception {
        String slimHost = this.page.getData().getVariable("SLIM_HOST");
        return slimHost == null ? "localhost" : slimHost;
    }

    public String getCommandLine() {
        return this.slimCommand;
    }

    @Override
    public void bye() throws Exception {
        this.slimClient.sendBye();
        if (!this.fastTest && !this.manualStart) {
            this.slimRunner.join();
        }
        if (this.fastTest) {
            this.slimRunner.kill();
        }
    }

    void createSlimService(String args) throws Exception {
        while (!this.tryCreateSlimService(args)) {
            Thread.sleep(10L);
        }
    }

    private boolean tryCreateSlimService(String args) throws SocketException {
        try {
            SlimService.main(args.trim().split(" "));
            return true;
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    void waitForConnection() throws Exception {
        while (!this.isConnected()) {
            Thread.sleep(50L);
        }
    }

    private boolean isConnected() throws Exception {
        try {
            this.slimClient.connect();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String runTestsAndGenerateHtml(PageData pageData) throws Exception {
        this.initializeTest();
        this.checkForAndReportVersionMismatch(pageData);
        String html = this.processAllTablesOnPage(pageData);
        this.testComplete(this.testSummary);
        return html;
    }

    private void initializeTest() {
        this.symbols.clear();
        this.scenarios.clear();
        this.testSummary.clear();
        this.allExpectations.clear();
        this.allInstructionResults.clear();
        this.allInstructions.clear();
        this.allTables.clear();
        this.exceptions.resetForNewTest();
    }

    private void checkForAndReportVersionMismatch(PageData pageData) throws Exception {
        double expectedVersionNumber = this.getExpectedSlimVersion(pageData);
        double serverVersionNumber = this.slimClient.getServerVersion();
        if (serverVersionNumber < expectedVersionNumber) {
            this.exceptions.addException("Slim Protocol Version Error", String.format("Expected V%s but was V%s", expectedVersionNumber, serverVersionNumber));
        }
    }

    private double getExpectedSlimVersion(PageData pageData) throws Exception {
        double expectedVersionNumber = SlimClient.MINIMUM_REQUIRED_SLIM_VERSION;
        String pageSpecificSlimVersion = pageData.getVariable("SLIM_VERSION");
        if (pageSpecificSlimVersion != null) {
            try {
                double pageSpecificSlimVersionDouble;
                expectedVersionNumber = pageSpecificSlimVersionDouble = Double.parseDouble(pageSpecificSlimVersion);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return expectedVersionNumber;
    }

    protected abstract String createHtmlResults(SlimTable var1, SlimTable var2) throws Exception;

    String processAllTablesOnPage(PageData pageData) throws Exception {
        this.tableScanner = this.scanTheTables(pageData);
        this.allTables = this.createSlimTables(this.tableScanner);
        this.testResults = pageData;
        boolean runAllTablesAtOnce = false;
        String htmlResults = "";
        if (runAllTablesAtOnce || this.allTables.size() == 0) {
            htmlResults = this.processTablesAndGetHtml(this.allTables, START_OF_TEST, END_OF_TEST);
        } else {
            ArrayList<SlimTable> oneTableList = new ArrayList<SlimTable>(1);
            for (int index = 0; index < this.allTables.size(); ++index) {
                SlimTable theTable = this.allTables.get(index);
                SlimTable startWithTable = index == 0 ? START_OF_TEST : theTable;
                SlimTable nextTable = index + 1 < this.allTables.size() ? this.allTables.get(index + 1) : END_OF_TEST;
                oneTableList.add(theTable);
                htmlResults = htmlResults + this.processTablesAndGetHtml(oneTableList, startWithTable, nextTable);
                oneTableList.clear();
            }
        }
        return htmlResults;
    }

    protected abstract TableScanner scanTheTables(PageData var1) throws Exception;

    private String processTablesAndGetHtml(List<SlimTable> tables, SlimTable startWithTable, SlimTable nextTable) throws Exception {
        this.expectations.clear();
        this.testTables = tables;
        this.instructions = this.createInstructions(tables);
        if (!this.exceptions.stopTestCalled()) {
            this.instructionResults = this.slimClient.invokeAndGetResponse(this.instructions);
        }
        String html = this.createHtmlResults(startWithTable, nextTable);
        this.acceptOutputFirst(html);
        this.allExpectations.addAll(this.expectations);
        this.allInstructions.addAll(this.instructions);
        this.allInstructionResults.putAll(this.instructionResults);
        return html;
    }

    private List<Object> createInstructions(List<SlimTable> tables) {
        ArrayList<Object> instructions = new ArrayList<Object>();
        for (SlimTable table : tables) {
            table.appendInstructions(instructions);
        }
        return instructions;
    }

    private List<SlimTable> createSlimTables(TableScanner tableScanner) {
        LinkedList<SlimTable> allTables = new LinkedList<SlimTable>();
        for (Table table : tableScanner) {
            String tableId;
            SlimTable slimTable = this.slimTableFactory.makeSlimTable(table, tableId = "" + allTables.size(), this);
            if (slimTable == null) continue;
            allTables.add(slimTable);
        }
        return allTables;
    }

    static String translateExceptionMessage(String exceptionMessage) {
        String[] tokens = exceptionMessage.split(" ");
        if (tokens[0].equals("COULD_NOT_INVOKE_CONSTRUCTOR")) {
            return "Could not invoke constructor for " + tokens[1];
        }
        if (tokens[0].equals("NO_METHOD_IN_CLASS")) {
            return String.format("Method %s not found in %s", tokens[1], tokens[2]);
        }
        if (tokens[0].equals("NO_CONSTRUCTOR")) {
            return String.format("Could not find constructor for %s", tokens[1]);
        }
        if (tokens[0].equals("NO_CONVERTER_FOR_ARGUMENT_NUMBER")) {
            return String.format("No converter for %s", tokens[1]);
        }
        if (tokens[0].equals("NO_INSTANCE")) {
            return String.format("The instance %s does not exist", tokens[1]);
        }
        if (tokens[0].equals("NO_CLASS")) {
            return String.format("Could not find class %s", tokens[1]);
        }
        if (tokens[0].equals("MALFORMED_INSTRUCTION")) {
            return String.format("The instruction %s is malformed", exceptionMessage.substring(exceptionMessage.indexOf(" ") + 1));
        }
        return exceptionMessage;
    }

    public PageData getTestResults() {
        return this.testResults;
    }

    public static String exceptionToString(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        e.printStackTrace(pw);
        return "__EXCEPTION__:" + stringWriter.toString();
    }

    public TestSummary getTestSummary() {
        return this.testSummary;
    }

    protected void evaluateExpectations() {
        for (SlimTable.Expectation e : this.expectations) {
            try {
                e.evaluateExpectation(this.instructionResults);
            }
            catch (Throwable ex) {
                this.exceptions.addException("ABORT", SlimTestSystem.exceptionToString(ex));
                this.exceptionOccurred(ex);
            }
        }
    }

    protected void evaluateTables() {
        this.evaluateExpectations();
        for (SlimTable table : this.testTables) {
            this.evaluateTable(table);
        }
    }

    private void evaluateTable(SlimTable table) {
        try {
            table.evaluateReturnValues(this.instructionResults);
            this.testSummary.add(table.getTestSummary());
        }
        catch (Throwable e) {
            this.exceptions.addException("ABORT", SlimTestSystem.exceptionToString(e));
            this.exceptionOccurred(e);
        }
    }

    protected void replaceExceptionsWithLinks() {
        Set<String> resultKeys = this.instructionResults.keySet();
        for (String resultKey : resultKeys) {
            this.replaceExceptionWithExceptionLink(resultKey);
        }
    }

    private void replaceExceptionWithExceptionLink(String resultKey) {
        Object result = this.instructionResults.get(resultKey);
        if (result instanceof String) {
            this.replaceIfUnignoredException(resultKey, (String)result);
        }
    }

    private void replaceIfUnignoredException(String resultKey, String resultString) {
        if (resultString.indexOf("__EXCEPTION__:") != -1 && this.shouldReportException(resultKey, resultString)) {
            this.processException(resultKey, resultString);
        }
    }

    private boolean shouldReportException(String resultKey, String resultString) {
        for (SlimTable table : this.testTables) {
            if (!table.shouldIgnoreException(resultKey, resultString)) continue;
            return false;
        }
        return true;
    }

    private void processException(String resultKey, String resultString) {
        Matcher exceptionMessageMatcher;
        ++this.testSummary.exceptions;
        boolean isStopTestException = resultString.contains("__EXCEPTION__:ABORT_SLIM_TEST:");
        if (isStopTestException) {
            this.exceptions.setStopTestCalled();
        }
        if ((exceptionMessageMatcher = this.exceptionMessagePattern.matcher(resultString)).find()) {
            String prefix = isStopTestException ? MESSAGE_FAIL : MESSAGE_ERROR;
            String exceptionMessage = exceptionMessageMatcher.group(1);
            this.instructionResults.put(resultKey, prefix + SlimTestSystem.translateExceptionMessage(exceptionMessage));
        } else {
            this.exceptions.addException(resultKey, resultString);
            this.instructionResults.put(resultKey, this.exceptionResult(resultKey));
        }
    }

    private String exceptionResult(String resultKey) {
        return String.format("Exception: <a href=#%s>%s</a>", resultKey, resultKey);
    }

    @Override
    public Map<String, ScenarioTable> getScenarios() {
        return this.scenarios;
    }

    public static void clearSlimPortOffset() {
        slimSocketOffset.set(0);
    }

    public List<SlimTable> getTestTables() {
        return this.allTables;
    }

    public List<Object> getInstructions() {
        return this.allInstructions;
    }

    public Map<String, Object> getInstructionResults() {
        return this.allInstructionResults;
    }

    public List<SlimTable.Expectation> getExpectations() {
        return this.allExpectations;
    }

    public Symbol getPreparsedScenarioLibrary() throws Exception {
        if (this.preparsedScenarioLibrary == null) {
            this.preparsedScenarioLibrary = Parser.make(this.page, this.getScenarioLibraryContent()).parse();
        }
        return this.preparsedScenarioLibrary;
    }

    private String getScenarioLibraryContent() throws Exception {
        String content = "!*> Precompiled Libraries\n\n";
        content = content + this.includeUncleLibraries();
        content = content + "*!\n";
        return content;
    }

    private String includeUncleLibraries() throws Exception {
        String content = "";
        List<WikiPage> uncles = PageCrawlerImpl.getAllUncles("ScenarioLibrary", this.page);
        Collections.reverse(uncles);
        for (WikiPage uncle : uncles) {
            content = content + this.include(this.page.getPageCrawler().getFullPath(uncle));
        }
        return content;
    }

    private String include(WikiPagePath path) {
        return "!include -c ." + path + "\n";
    }
}

