/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.converters.DateConverter;
import fitnesse.slim.test.TestSlimInterface;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public abstract class SlimMethodInvocationTestBase {
    protected StatementExecutorInterface caller;
    protected TestSlimInterface testSlim;
    protected String testClass = "TestSlim";

    @Before
    public abstract void setUp() throws Exception;

    protected abstract String getTestClassName();

    @Test
    public void callNiladicFunction() throws Exception {
        this.caller.call("testSlim", "nilad", new Object[0]);
        Assert.assertTrue((boolean)this.testSlim.niladWasCalled());
    }

    @Test
    public void throwMethodNotCalledErrorIfNoSuchMethod() throws Exception {
        String response;
        Assert.assertTrue((String)response, ((response = (String)this.caller.call("testSlim", "noSuchMethod", new Object[0])).indexOf("__EXCEPTION__:") != -1 && response.indexOf("message:<<NO_METHOD_IN_CLASS noSuchMethod[0] " + this.getTestClassName() + ".>>") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void methodReturnsString() throws Exception {
        Object retval = this.caller.call("testSlim", "returnString", new Object[0]);
        Assert.assertEquals((Object)"string", (Object)retval);
    }

    @Test
    public void methodReturnsInt() throws Exception {
        Object retval = this.caller.call("testSlim", "returnInt", new Object[0]);
        Assert.assertEquals((Object)"7", (Object)retval);
    }

    @Test
    public void methodReturnsVoid() throws Exception {
        Object retval = this.caller.call("testSlim", "nilad", new Object[0]);
        Assert.assertEquals((Object)"/__VOID__/", (Object)retval);
    }

    @Test
    public void methodTakesAndReturnsBooleanTrue() throws Exception {
        Object retval = this.caller.call("testSlim", "echoBoolean", "true");
        Assert.assertEquals((Object)"true", (Object)retval);
    }

    @Test
    public void methodTakesAndReturnsBooleanFalse() throws Exception {
        Object retval = this.caller.call("testSlim", "echoBoolean", "false");
        Assert.assertEquals((Object)"false", (Object)retval);
    }

    @Test
    public void passOneString() throws Exception {
        this.caller.call("testSlim", "oneString", "string");
        Assert.assertEquals((Object)"string", (Object)this.testSlim.getStringArg());
    }

    @Test
    public void passOneInt() throws Exception {
        this.caller.call("testSlim", "oneInt", "42");
        Assert.assertEquals((long)42L, (long)this.testSlim.getIntArg());
    }

    @Test
    public void passOneDouble() throws Exception {
        this.caller.call("testSlim", "oneDouble", "3.14159");
        Assert.assertEquals((double)3.14159, (double)this.testSlim.getDoubleArg(), (double)1.0E-6);
    }

    @Test
    public void passOneDate() throws Exception {
        this.caller.call("testSlim", "oneDate", "5-May-2009");
        Assert.assertEquals((Object)((Date)new DateConverter().fromString("5-May-2009")), (Object)this.testSlim.getDateArg());
    }

    @Test
    public void passOneList() throws Exception {
        this.caller.call("testSlim", "oneList", ListUtility.list("one", "two"));
        Assert.assertEquals(ListUtility.list("one", "two"), this.testSlim.getListArg());
    }

    @Test
    public void passManyArgs() throws Exception {
        this.caller.call("testSlim", "manyArgs", "1", "2.1", "c");
        Assert.assertEquals((long)1L, (long)this.testSlim.getIntegerObjectArg().intValue());
        Assert.assertEquals((double)2.1, (double)this.testSlim.getDoubleObjectArg(), (double)1.0E-5);
        Assert.assertEquals((long)99L, (long)this.testSlim.getCharArg());
    }

    @Test
    public void convertLists() throws Exception {
        this.caller.call("testSlim", "oneList", "[1 ,2, 3,4, hello Bob]");
        Assert.assertEquals(ListUtility.list("1", "2", "3", "4", "hello Bob"), (Object)this.caller.call("testSlim", "getListArg", new Object[0]));
    }

    @Test
    public void convertArraysOfStrings() throws Exception {
        this.caller.call("testSlim", "setStringArray", "[1 ,2, 3,4, hello Bob]");
        Assert.assertEquals((Object)"[1, 2, 3, 4, hello Bob]", (Object)this.caller.call("testSlim", "getStringArray", new Object[0]));
    }

    @Test
    public void convertArraysOfIntegers() throws Exception {
        this.caller.call("testSlim", "setIntegerArray", "[1 ,2, 3,4]");
        Assert.assertEquals((Object)"[1, 2, 3, 4]", (Object)this.caller.call("testSlim", "getIntegerArray", new Object[0]));
    }

    @Test
    public void convertArrayOfIntegersThrowsExceptionIfNotInteger() throws Exception {
        String resultString;
        Object result = this.caller.call("testSlim", "setIntegerArray", "[1 ,2, 3,4, hello]");
        Assert.assertTrue((String)resultString, ((resultString = (String)result).indexOf("message:<<CANT_CONVERT_TO_INTEGER_LIST>>") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void convertArraysOfBooleans() throws Exception {
        this.caller.call("testSlim", "setBooleanArray", "[true ,false, false,true]");
        Assert.assertEquals((Object)"[true, false, false, true]", (Object)this.caller.call("testSlim", "getBooleanArray", new Object[0]));
    }

    @Test
    public void convertArraysOfDoubles() throws Exception {
        this.caller.call("testSlim", "setDoubleArray", "[1 ,2.2, -3e2,0.04]");
        Assert.assertEquals((Object)"[1.0, 2.2, -300.0, 0.04]", (Object)this.caller.call("testSlim", "getDoubleArray", new Object[0]));
    }

    @Test
    public void convertArrayOfDoublesThrowsExceptionIfNotInteger() throws Exception {
        String resultString;
        Object result = this.caller.call("testSlim", "setDoubleArray", "[1 ,2, 3,4, hello]");
        Assert.assertTrue((String)resultString, ((resultString = (String)result).indexOf("message:<<CANT_CONVERT_TO_DOUBLE_LIST>>") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void handleReturnNull() throws Exception {
        Object result = this.caller.call("testSlim", "nullString", new Object[0]);
        Assert.assertNull((Object)result);
    }

    @Test
    public void handleEchoNull() throws Exception {
        Object result = this.caller.call("testSlim", "echoString", new Object[]{null});
        Assert.assertNull((Object)result);
    }

    @Test
    public void handleNullSymbols() throws Exception {
        this.caller.setVariable("x", null);
        Object result = this.caller.call("testSlim", "echoString", "$x");
        Assert.assertNull((Object)result);
    }

    @Test
    public void handleNullSymbolsSurroundedByString() throws Exception {
        this.caller.setVariable("x", null);
        Object result = this.caller.call("testSlim", "echoString", "A $x B");
        Assert.assertEquals((Object)"A null B", (Object)result);
    }

    @Test
    public void handleUnspecifiedSymbols() throws Exception {
        Object result = this.caller.call("testSlim", "echoString", "$x");
        Assert.assertEquals((Object)"$x", (Object)result);
    }
}

