/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.VersionInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class PageVersionPruner {
    public static int daysTillVersionsExpire = 14;

    public static void pruneVersions(FileSystemPage page, Collection<VersionInfo> versions) throws Exception {
        List<VersionInfo> versionsList = PageVersionPruner.makeSortedVersionList(versions);
        if (versions.size() > 0) {
            VersionInfo lastVersion = versionsList.get(versionsList.size() - 1);
            GregorianCalendar expirationDate = PageVersionPruner.makeVersionExpirationDate(lastVersion);
            for (VersionInfo version : versionsList) {
                PageVersionPruner.removeVersionIfExpired(page, version, expirationDate);
            }
        }
    }

    private static List<VersionInfo> makeSortedVersionList(Collection<VersionInfo> versions) throws Exception {
        ArrayList<VersionInfo> versionsList = new ArrayList<VersionInfo>(versions);
        Collections.sort(versionsList);
        return versionsList;
    }

    private static GregorianCalendar makeVersionExpirationDate(VersionInfo lastVersion) throws Exception {
        Date dateOfLastVersion = lastVersion.getCreationTime();
        GregorianCalendar expirationDate = new GregorianCalendar();
        expirationDate.setTime(dateOfLastVersion);
        expirationDate.add(5, -daysTillVersionsExpire);
        return expirationDate;
    }

    private static void removeVersionIfExpired(FileSystemPage page, VersionInfo version, GregorianCalendar expirationDate) throws Exception {
        GregorianCalendar thisDate = new GregorianCalendar();
        thisDate.setTime(version.getCreationTime());
        if (thisDate.before(expirationDate) || ((Calendar)thisDate).equals(expirationDate)) {
            page.removeVersion(version.getName());
        }
    }
}

