/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Scanner;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.TextMaker;
import fitnesse.wikitext.parser.VariableFinder;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiSourcePage;
import java.util.ArrayList;
import java.util.List;
import util.Maybe;

public class Parser {
    private static final ArrayList<Symbol> emptySymbols = new ArrayList();
    private ParsingPage currentPage;
    private VariableSource variableSource;
    private Scanner scanner;
    private Parser parent;
    private ParseSpecification specification;

    public static Parser make(WikiPage page, String input) {
        return Parser.make(new ParsingPage(new WikiSourcePage(page)), input);
    }

    public static Parser make(ParsingPage currentPage, String input) {
        return Parser.make(currentPage, input, SymbolProvider.wikiParsingProvider);
    }

    public static Parser make(ParsingPage currentPage, String input, SymbolProvider provider) {
        return Parser.make(currentPage, input, new VariableFinder(currentPage), provider);
    }

    public static Parser make(ParsingPage currentPage, String input, VariableSource variableSource, SymbolProvider provider) {
        ParseSpecification specification = new ParseSpecification().provider(provider);
        return new Parser(null, currentPage, new Scanner(new TextMaker(variableSource, currentPage.getNamedPage()), input), variableSource, specification);
    }

    public Parser(Parser parent, ParsingPage currentPage, Scanner scanner, VariableSource variableSource, ParseSpecification specification) {
        this.parent = parent;
        this.currentPage = currentPage;
        this.scanner = scanner;
        this.variableSource = variableSource;
        this.specification = specification;
    }

    public ParsingPage getPage() {
        return this.currentPage;
    }

    public VariableSource getVariableSource() {
        return this.variableSource;
    }

    public Symbol getCurrent() {
        return this.scanner.getCurrent();
    }

    public boolean atEnd() {
        return this.scanner.isEnd();
    }

    public boolean atLast() {
        return this.scanner.isLast();
    }

    public boolean isMoveNext(SymbolType type) {
        return this.moveNext(1).isType(type);
    }

    public Symbol moveNext(int count) {
        for (int i = 0; i < count; ++i) {
            this.scanner.moveNext();
        }
        return this.scanner.getCurrent();
    }

    public List<Symbol> moveNext(SymbolType[] symbolTypes) {
        ArrayList<Symbol> tokens = new ArrayList<Symbol>();
        for (SymbolType type : symbolTypes) {
            Symbol current = this.moveNext(1);
            if (!current.isType(type)) {
                return new ArrayList<Symbol>();
            }
            tokens.add(current);
        }
        return tokens;
    }

    public List<Symbol> peek(SymbolType[] types) {
        List<Symbol> lookAhead = this.scanner.peek(types.length, new ParseSpecification().provider(this.specification));
        if (lookAhead.size() != types.length) {
            return emptySymbols;
        }
        for (int i = 0; i < lookAhead.size(); ++i) {
            if (lookAhead.get(i).isType(types[i])) continue;
            return emptySymbols;
        }
        return lookAhead;
    }

    public String parseToAsString(SymbolType terminator) {
        int start = this.scanner.getOffset();
        this.scanner.markStart();
        this.parseTo(terminator);
        return this.scanner.stringFromStart(start);
    }

    public String parseLiteral(SymbolType terminator) {
        return this.scanner.makeLiteral(terminator).getContent();
    }

    public Symbol parse(String input) {
        return this.parseWithParent(input, this);
    }

    public Symbol parseWithParent(String input, Parser parent) {
        return new Parser(parent, this.currentPage, new Scanner(new TextMaker(this.variableSource, this.currentPage.getNamedPage()), input), this.variableSource, new ParseSpecification().provider(this.specification)).parse();
    }

    public Symbol parseToIgnoreFirst(SymbolType type) {
        return this.parseToIgnoreFirst(new SymbolType[]{type});
    }

    public Symbol parseToIgnoreFirst(SymbolType[] types) {
        ParseSpecification newSpecification = new ParseSpecification().provider(this.specification);
        for (SymbolType symbolType : types) {
            newSpecification.terminator(symbolType);
            newSpecification.ignoreFirst(symbolType);
        }
        return this.parse(newSpecification);
    }

    public Symbol parseToIgnoreFirstWithSymbols(SymbolType ignore, SymbolProvider provider) {
        return this.parse(new ParseSpecification().ignoreFirst(ignore).terminator(ignore).provider(provider));
    }

    public Symbol parseTo(SymbolType terminator) {
        return this.parseTo(terminator, 0);
    }

    public Symbol parseTo(SymbolType terminator, int priority) {
        return this.parse(new ParseSpecification().terminator(terminator).priority(priority));
    }

    public Symbol parseToWithSymbols(SymbolType terminator, SymbolProvider provider, int priority) {
        SymbolType[] terminators = new SymbolType[]{terminator};
        return this.parseToWithSymbols(terminators, provider, priority);
    }

    public Symbol parseToWithSymbols(SymbolType[] terminators, SymbolProvider provider, int priority) {
        ParseSpecification newSpecification = new ParseSpecification().provider(provider).priority(priority);
        for (SymbolType terminator : terminators) {
            newSpecification.terminator(terminator);
        }
        return this.parse(newSpecification);
    }

    public Symbol parseToEnd(SymbolType end) {
        return this.parse(new ParseSpecification().end(end));
    }

    public Symbol parseToEnds(int priority, SymbolProvider provider, SymbolType[] moreEnds) {
        ParseSpecification newSpecification = this.specification.makeSpecification(provider, moreEnds).priority(priority);
        for (SymbolType end : moreEnds) {
            newSpecification.end(end);
        }
        return this.parse(newSpecification);
    }

    private Symbol parse(ParseSpecification newSpecification) {
        return new Parser(this, this.currentPage, this.scanner, this.variableSource, newSpecification).parse();
    }

    public Symbol parse() {
        Symbol result = new Symbol(SymbolType.SymbolList);
        while (true) {
            Scanner backup = new Scanner(this.scanner);
            this.scanner.moveNextIgnoreFirst(this.specification);
            if (this.scanner.isEnd()) break;
            Symbol currentToken = this.scanner.getCurrent();
            if (this.specification.endsOn(currentToken.getType()) || this.parentOwns(currentToken.getType(), this.specification)) {
                this.scanner.copy(backup);
                break;
            }
            if (this.specification.terminatesOn(currentToken.getType())) break;
            Rule currentRule = currentToken.getType().getWikiRule();
            if (currentRule != null) {
                Maybe<Symbol> parsedSymbol = currentRule.parse(currentToken, this);
                if (parsedSymbol.isNothing()) {
                    this.specification.ignoreFirst(currentToken.getType());
                    this.scanner.copy(backup);
                    continue;
                }
                result.add(parsedSymbol.getValue());
                this.specification.clearIgnoresFirst();
                continue;
            }
            result.add(currentToken);
            this.specification.clearIgnoresFirst();
        }
        return result;
    }

    private boolean parentOwns(SymbolType current, ParseSpecification specification) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.specification.hasPriority(specification) && this.parent.specification.terminatesOn(current)) {
            return true;
        }
        return this.parent.parentOwns(current, specification);
    }
}

