/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.WidgetWithTextArgument;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XRefWidget
extends ParentWidget
implements WidgetWithTextArgument {
    public static final String REGEXP = "^!see (?:[<>^.])?(?:\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+[.]?)+\\b";
    private static final Pattern pattern = Pattern.compile("^!see (.*)");
    private String pageName;

    public XRefWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.pageName = match.group(1);
            this.addChildWidgets(this.pageName);
        }
    }

    @Override
    public String render() throws Exception {
        return HtmlUtil.metaText("<b>See: " + this.childHtml() + "</b>");
    }

    @Override
    public String asWikiText() throws Exception {
        return "!see " + this.pageName;
    }

    @Override
    public String getText() {
        return this.pageName;
    }
}

