/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.parser.WikiTranslator;

public abstract class ReferenceRenamer
implements TraversalListener,
SymbolTreeWalker {
    protected WikiPage root;
    protected WikiPage currentPage;

    public ReferenceRenamer(WikiPage root) {
        this.root = root;
    }

    public void renameReferences() throws Exception {
        this.root.getPageCrawler().traverse(this.root, this);
    }

    @Override
    public void processPage(WikiPage currentPage) throws Exception {
        boolean pageHasChanged;
        PageData data = currentPage.getData();
        String content = data.getContent();
        Symbol syntaxTree = Parser.make(new ParsingPage(new WikiSourcePage(currentPage)), content, SymbolProvider.refactoringProvider).parse();
        this.currentPage = currentPage;
        syntaxTree.walkPreOrder(this);
        String newContent = new WikiTranslator(new WikiSourcePage(currentPage)).translateTree(syntaxTree);
        boolean bl = pageHasChanged = !newContent.equals(content);
        if (pageHasChanged) {
            data.setContent(newContent);
            currentPage.commit(data);
        }
    }
}

