/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.SuiteFilter;
import fitnesse.responders.run.SuiteSpecificationRunner;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class SuiteContentsFinder {
    public static final String SUITE_SETUP_NAME = "SuiteSetUp";
    public static final String SUITE_TEARDOWN_NAME = "SuiteTearDown";
    private final WikiPage pageToRun;
    private final WikiPage wikiRootPage;
    private final SuiteFilter suiteFilter;
    private LinkedList<WikiPage> testPageList;

    public SuiteContentsFinder(WikiPage pageToRun, SuiteFilter suiteFilter, WikiPage root) {
        this.pageToRun = pageToRun;
        this.wikiRootPage = root;
        this.suiteFilter = suiteFilter != null ? suiteFilter : SuiteFilter.MATCH_ALL;
        this.testPageList = new LinkedList();
    }

    public List<WikiPage> makePageListForSingleTest() throws Exception {
        this.testPageList = new LinkedList();
        this.testPageList.add(this.pageToRun);
        return this.testPageList;
    }

    public List<WikiPage> makePageList() throws Exception {
        this.getAllPagesToRunForThisSuite();
        if (this.testPageList.isEmpty()) {
            String name = new WikiPagePath(this.pageToRun).toString();
            WikiPageDummy dummy = new WikiPageDummy("", "|Comment|\n|No test found with " + this.suiteFilter.toString() + " in subwiki !-" + name + "-!!|\n");
            dummy.setParent(this.wikiRootPage);
            this.testPageList.add(dummy);
        }
        return this.testPageList;
    }

    public LinkedList<WikiPage> getAllPagesToRunForThisSuite() throws Exception {
        String content = this.pageToRun.getData().getHtml();
        if (SuiteSpecificationRunner.isASuiteSpecificationsPage(content)) {
            SuiteSpecificationRunner runner = new SuiteSpecificationRunner(this.wikiRootPage);
            if (runner.getPageListFromPageContent(content)) {
                this.testPageList = runner.testPageList;
            }
        } else {
            this.testPageList = this.getAllTestPagesUnder();
            List<WikiPage> referencedPages = this.gatherCrossReferencedTestPages();
            this.testPageList.addAll(referencedPages);
        }
        return this.testPageList;
    }

    private LinkedList<WikiPage> getAllTestPagesUnder() throws Exception {
        LinkedList<WikiPage> testPages = new LinkedList<WikiPage>();
        this.addTestPagesToSuite(testPages, this.pageToRun, this.suiteFilter);
        Collections.sort(testPages, new Comparator<WikiPage>(){

            @Override
            public int compare(WikiPage p1, WikiPage p2) {
                try {
                    PageCrawler crawler = p1.getPageCrawler();
                    WikiPagePath path1 = crawler.getFullPath(p1);
                    WikiPagePath path2 = crawler.getFullPath(p2);
                    return path1.compareTo(path2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        return testPages;
    }

    private void addTestPagesToSuite(List<WikiPage> suite, WikiPage page, SuiteFilter suiteFilter) throws Exception {
        if (suiteFilter.isMatchingTest(page)) {
            suite.add(page);
        }
        SuiteFilter suiteFilterForChildren = suiteFilter.getFilterForTestsInSuite(page);
        List<WikiPage> children = SuiteContentsFinder.getChildren(page);
        for (WikiPage child : children) {
            this.addTestPagesToSuite(suite, child, suiteFilterForChildren);
        }
    }

    private static List<WikiPage> getChildren(WikiPage page) throws Exception {
        ArrayList<WikiPage> children = new ArrayList<WikiPage>();
        children.addAll(page.getChildren());
        SuiteContentsFinder.addVirtualChildrenIfAny(page, children);
        return children;
    }

    private static void addVirtualChildrenIfAny(WikiPage context, List<WikiPage> children) throws Exception {
        if (context.hasExtension("VirtualCoupling")) {
            VirtualCouplingExtension extension = (VirtualCouplingExtension)context.getExtension("VirtualCoupling");
            children.addAll(extension.getVirtualCoupling().getChildren());
        }
    }

    protected List<WikiPage> gatherCrossReferencedTestPages() throws Exception {
        LinkedList<WikiPage> pages = new LinkedList<WikiPage>();
        this.addAllXRefs(pages, this.pageToRun);
        return pages;
    }

    private void addAllXRefs(List<WikiPage> xrefPages, WikiPage page) throws Exception {
        List<WikiPage> children = page.getChildren();
        this.addXrefPages(xrefPages, page);
        for (WikiPage child : children) {
            this.addAllXRefs(xrefPages, child);
        }
    }

    private void addXrefPages(List<WikiPage> pages, WikiPage thePage) throws Exception {
        PageData data = thePage.getData();
        List<String> pageReferences = data.getXrefPages();
        PageCrawler crawler = thePage.getPageCrawler();
        WikiPagePath testPagePath = crawler.getFullPath(thePage);
        WikiPage parent = crawler.getPage(this.wikiRootPage, testPagePath.parentPath());
        for (String pageReference : pageReferences) {
            WikiPagePath path = PathParser.parse(pageReference);
            WikiPage referencedPage = crawler.getPage(parent, path);
            if (referencedPage == null) continue;
            pages.add(referencedPage);
        }
    }

    public static boolean isSuiteSetupOrTearDown(WikiPage testPage) throws Exception {
        String name = testPage.getName();
        return SUITE_SETUP_NAME.equals(name) || SUITE_TEARDOWN_NAME.equals(name);
    }
}

