/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.testHistory.HistoryComparer;
import fitnesse.slimTables.HtmlTableScanner;
import fitnesse.slimTables.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TableListComparer {
    private HtmlTableScanner leftHandScanner;
    private HtmlTableScanner rightHandScanner;
    protected ArrayList<HistoryComparer.MatchedPair> tableMatches;

    public TableListComparer(HtmlTableScanner leftHandScanner, HtmlTableScanner rightHandScanner) {
        this.leftHandScanner = leftHandScanner;
        this.rightHandScanner = rightHandScanner;
        this.tableMatches = new ArrayList();
    }

    public void compareAllTables() {
        for (int leftTableIndex = 0; leftTableIndex < this.leftHandScanner.getTableCount(); ++leftTableIndex) {
            for (int rightTableIndex = 0; rightTableIndex < this.rightHandScanner.getTableCount(); ++rightTableIndex) {
                double score = this.compareTables(leftTableIndex, rightTableIndex);
                this.saveMatch(leftTableIndex, rightTableIndex, score);
            }
        }
        this.sortMatchesByScore();
        this.saveOnlyTheBestMatches();
        this.sortMatchesByTableIndex();
    }

    private double compareTables(int leftTableIndex, int rightTableIndex) {
        Table table1 = this.leftHandScanner.getTable(leftTableIndex);
        Table table2 = this.rightHandScanner.getTable(rightTableIndex);
        return this.compareTables(table1, table2);
    }

    double compareTables(Table table1, Table table2) {
        return new TableComparer(table1, table2).compareRowsOfTables();
    }

    public boolean theTablesMatch(double score) {
        return score >= 0.8;
    }

    public void saveMatch(int leftTableIndex, int rightTableIndex, double score) {
        if (!this.theTablesMatch(score)) {
            return;
        }
        this.tableMatches.add(new HistoryComparer.MatchedPair(leftTableIndex, rightTableIndex, score));
    }

    public void saveOnlyTheBestMatches() {
        for (int matchIndex = 0; matchIndex < this.tableMatches.size(); ++matchIndex) {
            for (int secondMatchIndex = matchIndex + 1; secondMatchIndex < this.tableMatches.size(); ++secondMatchIndex) {
                if (this.tableMatches.get((int)matchIndex).first == this.tableMatches.get((int)secondMatchIndex).first) {
                    this.tableMatches.remove(secondMatchIndex);
                    --secondMatchIndex;
                    continue;
                }
                if (this.tableMatches.get((int)matchIndex).second != this.tableMatches.get((int)secondMatchIndex).second) continue;
                this.tableMatches.remove(secondMatchIndex);
                --secondMatchIndex;
            }
        }
    }

    public void sortMatchesByScore() {
        Collections.sort(this.tableMatches, new Comparator<HistoryComparer.MatchedPair>(){

            @Override
            public int compare(HistoryComparer.MatchedPair match1, HistoryComparer.MatchedPair match2) {
                if (match1.matchScore > match2.matchScore) {
                    return -1;
                }
                if (match1.matchScore < match2.matchScore) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void sortMatchesByTableIndex() {
        Collections.sort(this.tableMatches, new Comparator<HistoryComparer.MatchedPair>(){

            @Override
            public int compare(HistoryComparer.MatchedPair match1, HistoryComparer.MatchedPair match2) {
                if (match1.first > match2.first) {
                    return 1;
                }
                if (match1.first < match2.first) {
                    return -1;
                }
                return 0;
            }
        });
    }

    static class TableComparer {
        private Table table1;
        private Table table2;
        private int table1rows;
        private int table2rows;

        public TableComparer(Table table1, Table table2) {
            this.table1 = table1;
            this.table2 = table2;
            this.table1rows = table1.getRowCount();
            this.table2rows = table2.getRowCount();
        }

        public double compareRowsOfTables() {
            if (this.table1rows != this.table2rows) {
                return 0.0;
            }
            return this.scoreRowContent() + this.scoreRowTopology() + this.scoreTableTopology();
        }

        private double scoreTableTopology() {
            int cellCountForTable1 = 0;
            int cellCountForTable2 = 0;
            for (int row = 0; row < this.table1rows; ++row) {
                cellCountForTable1 += this.table1.getColumnCountInRow(row);
                cellCountForTable2 += this.table2.getColumnCountInRow(row);
            }
            if (cellCountForTable1 == cellCountForTable2) {
                return 0.1;
            }
            return 0.0;
        }

        private double scoreRowContent() {
            double colScore = 0.0;
            for (int row = 0; row < this.table1rows; ++row) {
                colScore += this.compareCellsInRow(row);
            }
            return colScore * 2.0 / (double)(this.table1rows + this.table2rows);
        }

        private double scoreRowTopology() {
            double score = 0.0;
            for (int row = 0; row < this.table1rows; ++row) {
                int table2Cols;
                int table1Cols = this.table1.getColumnCountInRow(row);
                if (table1Cols != (table2Cols = this.table2.getColumnCountInRow(row))) continue;
                score += 0.1 * (2.0 / (double)(this.table1rows + this.table2rows));
            }
            return score;
        }

        private double compareCellsInRow(int row) {
            double score = 0.0;
            int table1Cols = this.table1.getColumnCountInRow(row);
            int table2Cols = this.table2.getColumnCountInRow(row);
            int minNumberOfCols = Math.min(table1Cols, table2Cols);
            for (int col = 0; col < minNumberOfCols; ++col) {
                score += this.calculateScoreForCell(row, col);
            }
            return score /= (double)(table1Cols + table2Cols);
        }

        private double calculateScoreForCell(int row, int col) {
            return this.scoreCellPassFailResult(row, col) + this.scoreCellContent(row, col);
        }

        private double scoreCellContent(int row, int col) {
            String content2;
            String content1 = this.table1.getCellContents(col, row);
            if (this.contentMatches(content1, content2 = this.table2.getCellContents(col, row))) {
                return 1.0;
            }
            return 0.0;
        }

        private boolean contentMatches(String content1, String content2) {
            return this.areEqualAndNotScenarioCalls(content1, content2) || this.bothAreScenarioCalls(content1, content2);
        }

        private boolean bothAreScenarioCalls(String content1, String content2) {
            return this.isCalledScenario(content1) && this.isCalledScenario(content2);
        }

        private boolean areEqualAndNotScenarioCalls(String content1, String content2) {
            return !this.isCalledScenario(content1) && !this.isCalledScenario(content2) && content1.equals(content2);
        }

        private double scoreCellPassFailResult(int row, int col) {
            String content2;
            String content1 = this.table1.getCellResult(col, row);
            return content1.equals(content2 = this.table2.getCellResult(col, row)) ? 1.0 : 0.0;
        }

        private boolean isCalledScenario(String content1) {
            return content1.contains("<div class=\"collapse_rim\">");
        }
    }
}

