/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class VersionSelectionResponder
implements SecureResponder {
    private WikiPage page;
    private List<VersionInfo> versions;
    private List<String> ageStrings;
    private PageData pageData;
    private String resource;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        SimpleResponse response = new SimpleResponse();
        this.resource = request.getResource();
        WikiPagePath path = PathParser.parse(this.resource);
        this.page = context.root.getPageCrawler().getPage(context.root, path);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.pageData = this.page.getData();
        this.versions = VersionSelectionResponder.getVersionsList(this.pageData);
        this.ageStrings = new ArrayList<String>();
        Date now = new GregorianCalendar().getTime();
        for (VersionInfo version : this.versions) {
            this.ageStrings.add(VersionSelectionResponder.howLongAgoString(now, version.getCreationTime()));
        }
        response.setContent(this.makeHtml(context));
        return response;
    }

    public String makeHtml(FitNesseContext context) throws Exception {
        HtmlPage html = context.htmlPageFactory.newPage();
        html.title.use("Version Selection: " + this.resource);
        html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Version Selection"));
        html.main.use(this.makeRightColumn());
        return html.html();
    }

    public HtmlTag makeRightColumn() throws Exception {
        TagGroup group = new TagGroup();
        group.add(new HtmlTag("h3", "Select a version."));
        HtmlTag form = new HtmlTag("form");
        String fullPathName = PathParser.render(this.page.getPageCrawler().getFullPath(this.page));
        form.addAttribute("action", fullPathName);
        form.addAttribute("method", "get");
        form.add(HtmlUtil.makeInputTag("hidden", "responder", "viewVersion"));
        HtmlTag table = new HtmlTag("table");
        table.addAttribute("cellspacing", "0");
        table.add(this.makeRow("th", new RawHtml("&nbsp;"), "Name", "Author", "Age"));
        for (int i = 0; i < this.versions.size(); ++i) {
            table.add(this.makeVersionRow(i));
        }
        form.add(table);
        form.add(HtmlUtil.makeInputTag("submit", "save", "View Version"));
        group.add(form);
        return group;
    }

    private HtmlTag makeVersionRow(int index) {
        VersionInfo version = this.versions.get(index);
        HtmlTag input = HtmlUtil.makeInputTag("radio", "version", version.getName());
        return this.makeRow("td", input, version.getName(), version.getAuthor(), this.ageStrings.get(index).toString());
    }

    private HtmlTag makeRow(String cellType, HtmlElement input, String name, String author, String age) {
        HtmlTag row = new HtmlTag("tr");
        row.add(new HtmlTag(cellType, input));
        row.add(new HtmlTag(cellType, name));
        row.add(new HtmlTag(cellType, author));
        row.add(new HtmlTag(cellType, age));
        return row;
    }

    public static List<VersionInfo> getVersionsList(PageData data) {
        ArrayList<VersionInfo> list = new ArrayList<VersionInfo>(data.getVersions());
        Collections.sort(list);
        Collections.reverse(list);
        return list;
    }

    public static String howLongAgoString(Date now, Date then) {
        long time = Math.abs(now.getTime() - then.getTime()) / 1000L;
        if (time < 60L) {
            return VersionSelectionResponder.pluralize(time, "second");
        }
        if (time < 3600L) {
            return VersionSelectionResponder.pluralize(time / 60L, "minute");
        }
        if (time < 86400L) {
            return VersionSelectionResponder.pluralize(time / 3600L, "hour");
        }
        if (time < 31536000L) {
            return VersionSelectionResponder.pluralize(time / 86400L, "day");
        }
        return VersionSelectionResponder.pluralize(time / 31536000L, "year");
    }

    private static String pluralize(long time, String unit) {
        String age = time + " " + unit;
        if (time > 1L) {
            age = age + "s";
        }
        return age;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

