/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.test;

import java.util.List;
import util.ListUtility;

public class Bowling {
    private Game g;

    public List<?> doTable(List<Object> table) {
        this.g = new Game();
        List<String> rollResults = ListUtility.list("", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        List<String> scoreResults = ListUtility.list("", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        this.rollBalls(table);
        this.evaluateScores(this.g, (List)table.get(1), scoreResults);
        return ListUtility.list(rollResults, scoreResults);
    }

    private void evaluateScores(Game g, List<String> object, List<String> scoreResults) {
        for (int frame = 0; frame < 10; ++frame) {
            int actualScore = g.score(frame + 1);
            int expectedScore = Integer.parseInt(object.get(this.frameCoordinate(frame)));
            if (expectedScore == actualScore) {
                scoreResults.set(this.frameCoordinate(frame), "pass");
                continue;
            }
            scoreResults.set(this.frameCoordinate(frame), String.format("Was:%d, expected:%s.", actualScore, expectedScore));
        }
    }

    private int frameCoordinate(int frame) {
        return frame < 9 ? frame * 2 + 1 : frame * 2 + 2;
    }

    private void rollBalls(List<Object> table) {
        List rollRow = (List)table.get(0);
        for (int frame = 0; frame < 10; ++frame) {
            String firstRoll = (String)rollRow.get(frame * 2);
            String secondRoll = (String)rollRow.get(frame * 2 + 1);
            this.rollFrame(firstRoll, secondRoll);
        }
    }

    private void rollFrame(String firstRoll, String secondRoll) {
        if (firstRoll.equalsIgnoreCase("X")) {
            this.g.roll(10);
        } else {
            int firstRollInt = this.parseFirstRoll(firstRoll);
            this.parseSecondRoll(secondRoll, firstRollInt);
        }
    }

    private void parseSecondRoll(String secondRoll, int firstRollInt) {
        if (secondRoll.equals("/")) {
            this.g.roll(10 - firstRollInt);
        } else if (secondRoll.equals("-")) {
            this.g.roll(0);
        } else {
            this.g.roll(Integer.parseInt(secondRoll));
        }
    }

    private int parseFirstRoll(String firstRoll) {
        int firstRollInt = 0;
        if (firstRoll.equals("-")) {
            this.g.roll(0);
        } else {
            firstRollInt = Integer.parseInt(firstRoll);
            this.g.roll(firstRollInt);
        }
        return firstRollInt;
    }

    private class Game {
        int[] rolls = new int[21];
        int currentRoll = 0;

        private Game() {
        }

        public void roll(int pins) {
            this.rolls[this.currentRoll++] = pins;
        }

        public int score(int frame) {
            return new Scorer(frame).score();
        }

        private class Scorer {
            private int frame;
            private int score;
            private int firstBall;

            public Scorer(int frame) {
                this.frame = frame;
                this.score = 0;
                this.firstBall = 0;
            }

            public int score() {
                for (int f = 0; f < this.frame; ++f) {
                    this.scoreFrame();
                }
                return this.score;
            }

            private void scoreFrame() {
                if (this.isStrike(this.firstBall)) {
                    this.scoreStrike();
                } else if (this.isSpare(this.firstBall)) {
                    this.scoreSpare();
                } else {
                    this.scoreNoMark();
                }
            }

            private void scoreNoMark() {
                this.score += this.twoBallsInFrame(this.firstBall);
                this.firstBall += 2;
            }

            private void scoreSpare() {
                this.score += 10 + this.nextBallForSpare(this.firstBall);
                this.firstBall += 2;
            }

            private void scoreStrike() {
                this.score += 10 + this.nextTwoBallsForStrike(this.firstBall);
                ++this.firstBall;
            }

            private int twoBallsInFrame(int firstBall) {
                return Game.this.rolls[firstBall] + Game.this.rolls[firstBall + 1];
            }

            private int nextBallForSpare(int firstBall) {
                return Game.this.rolls[firstBall + 2];
            }

            private int nextTwoBallsForStrike(int firstBall) {
                return Game.this.rolls[firstBall + 1] + Game.this.rolls[firstBall + 2];
            }

            private boolean isSpare(int firstBall) {
                return Game.this.rolls[firstBall] + Game.this.rolls[firstBall + 1] == 10;
            }

            private boolean isStrike(int firstBall) {
                return Game.this.rolls[firstBall] == 10;
            }
        }
    }
}

