/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matchable;
import fitnesse.wikitext.parser.MatchableFilter;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import java.util.ArrayList;
import java.util.Arrays;

public class ParseSpecification {
    private SymbolProvider provider = SymbolProvider.wikiParsingProvider;
    private ArrayList<SymbolType> terminators = new ArrayList();
    private ArrayList<SymbolType> ignoresFirst = new ArrayList();
    private ArrayList<SymbolType> ends = new ArrayList();
    private int priority = 0;

    public ParseSpecification provider(SymbolProvider provider) {
        this.provider = provider;
        return this;
    }

    public ParseSpecification provider(ParseSpecification specification) {
        this.provider = specification.provider;
        return this;
    }

    public ParseSpecification priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ParseSpecification terminator(SymbolType terminator) {
        this.terminators.add(terminator);
        return this;
    }

    public ParseSpecification ignoreFirst(SymbolType ignoreFirst) {
        this.ignoresFirst.add(ignoreFirst);
        return this;
    }

    public void clearIgnoresFirst() {
        this.ignoresFirst.clear();
    }

    public ParseSpecification end(SymbolType end) {
        this.ends.add(end);
        return this;
    }

    public ParseSpecification makeSpecification(SymbolProvider providerModel, SymbolType[] providerTypes) {
        SymbolProvider newProvider = new SymbolProvider(providerModel);
        newProvider.addTypes(this.ends);
        newProvider.addTypes(this.terminators);
        newProvider.addTypes(Arrays.asList(providerTypes));
        return new ParseSpecification().provider(newProvider);
    }

    public boolean ignores(Matchable symbolType) {
        return this.contains(this.ignoresFirst, symbolType);
    }

    public boolean terminatesOn(SymbolType symbolType) {
        return this.contains(this.terminators, symbolType);
    }

    public boolean endsOn(SymbolType symbolType) {
        return this.contains(this.ends, symbolType);
    }

    public boolean hasPriority(ParseSpecification other) {
        return this.priority > other.priority;
    }

    public SymbolMatch findMatch(ScanString input, MatchableFilter filter) {
        return this.provider.findMatch(input, filter);
    }

    public boolean matchesFor(SymbolType symbolType) {
        return this.provider.matchesFor(symbolType);
    }

    private boolean contains(Iterable<SymbolType> terminators, Matchable currentType) {
        for (SymbolType terminator : terminators) {
            if (!currentType.matchesFor(terminator)) continue;
            return true;
        }
        return false;
    }
}

