/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Comment;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.VariableSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import util.Maybe;

public class Symbol {
    public static Maybe<Symbol> nothing = new Maybe();
    private SymbolType type;
    private String content = "";
    private List<Symbol> children = new ArrayList<Symbol>();
    private HashMap<String, String> variables;
    private HashMap<String, String> properties;

    public Symbol(SymbolType type) {
        this.type = type;
    }

    public Symbol(SymbolType type, String content) {
        this.content = content;
        this.type = type;
    }

    public SymbolType getType() {
        return this.type;
    }

    public boolean isType(SymbolType type) {
        return this.type.matchesFor(type);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Symbol childAt(int index) {
        return this.getChildren().get(index);
    }

    public Symbol lastChild() {
        return this.childAt(this.getChildren().size() - 1);
    }

    public List<Symbol> getChildren() {
        return this.children;
    }

    public Symbol addToFront(Symbol child) {
        ArrayList<Symbol> newChildren = new ArrayList<Symbol>();
        newChildren.add(child);
        newChildren.addAll(this.children);
        this.children = newChildren;
        return this;
    }

    public Symbol add(Symbol child) {
        this.children.add(child);
        return this;
    }

    public Symbol add(String text) {
        this.children.add(new Symbol(SymbolType.Text, text));
        return this;
    }

    public Symbol childrenAfter(int after) {
        Symbol result = new Symbol(SymbolType.SymbolList);
        for (int i = after + 1; i < this.children.size(); ++i) {
            result.add(this.children.get(i));
        }
        return result;
    }

    public boolean walkPostOrder(SymbolTreeWalker walker) {
        if (walker.visitChildren(this)) {
            for (Symbol child : this.children) {
                if (child.walkPostOrder(walker)) continue;
                return false;
            }
        }
        return walker.visit(this);
    }

    public boolean walkPreOrder(SymbolTreeWalker walker) {
        if (!walker.visit(this)) {
            return false;
        }
        if (walker.visitChildren(this)) {
            for (Symbol child : this.children) {
                if (child.walkPreOrder(walker)) continue;
                return false;
            }
        }
        return true;
    }

    public void evaluateVariables(String[] names, VariableSource source) {
        if (this.variables == null) {
            this.variables = new HashMap();
        }
        for (String name : names) {
            Maybe<String> value = source.findVariable(name);
            if (value.isNothing()) continue;
            this.variables.put(name, value.getValue());
        }
    }

    public String getVariable(String name, String defaultValue) {
        return this.variables != null && this.variables.containsKey(name) ? this.variables.get(name) : defaultValue;
    }

    public Symbol putProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return this;
    }

    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties != null && this.properties.containsKey(key) ? this.properties.get(key) : defaultValue;
    }

    public String getProperty(String key) {
        return this.getProperty(key, "");
    }

    public SymbolType closeType() {
        return this.type == SymbolType.OpenBrace ? SymbolType.CloseBrace : (this.type == SymbolType.OpenBracket ? SymbolType.CloseBracket : (this.type == SymbolType.OpenParenthesis ? SymbolType.CloseParenthesis : (this.type == Literal.symbolType ? SymbolType.CloseLiteral : (this.type == Comment.symbolType ? SymbolType.Newline : SymbolType.Empty))));
    }
}

