/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Date;
import util.SystemClock;

public abstract class Clock {
    protected static final SystemClock SYSTEM_CLOCK = new SystemClock();
    protected static Clock instance;

    protected Clock() {
        this(false);
    }

    protected Clock(boolean setAsInstance) {
        if (setAsInstance) {
            instance = this;
        }
    }

    abstract long currentClockTimeInMillis();

    Date currentClockDate() {
        return new Date(this.currentClockTimeInMillis());
    }

    public static long currentTimeInMillis() {
        return instance.currentClockTimeInMillis();
    }

    public static Date currentDate() {
        return instance.currentClockDate();
    }

    public static void restoreDefaultClock() {
        instance = SYSTEM_CLOCK;
    }

    static {
        Clock.restoreDefaultClock();
    }
}

