/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;

public class FBBlobField
extends FBField
implements FBFlushableField {
    private static final int BUFF_SIZE = 4096;
    private boolean isCachedData = false;
    private FBBlob blob;
    int length;
    byte[] data;

    FBBlobField(XSQLVAR field, FBResultSet rs, int numCol, int requiredType) throws SQLException {
        super(field, rs, numCol, requiredType);
    }

    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.close();
            }
        }
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        finally {
            this.blob = null;
        }
    }

    public Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        byte[] bytes = this.rs.row[this.numCol];
        if (bytes == null) {
            return BLOB_NULL_VALUE;
        }
        this.blob = new FBBlob(this.c, this.field.decodeLong(bytes));
        return this.blob;
    }

    public InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.field.sqlsubtype < 0) {
            throw (SQLException)FBBlobField.createException(BINARY_STREAM_CONVERSION_ERROR).fillInStackTrace();
        }
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return STREAM_NULL_VALUE;
        }
        return blob.getBinaryStream();
    }

    public byte[] getBytes() throws SQLException {
        if (this.field.sqlsubtype < 0) {
            throw (SQLException)FBBlobField.createException(BYTES_CONVERSION_ERROR);
        }
        return this.getBytesInternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytesInternal() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        InputStream in = blob.getBinaryStream();
        if (in == STREAM_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int counter = 0;
        try {
            try {
                while ((counter = in.read(buff)) != -1) {
                    bout.write(buff, 0, counter);
                }
                Object var8_6 = null;
            }
            catch (IOException ioex) {
                throw (SQLException)FBBlobField.createException(BYTES_CONVERSION_ERROR + " " + ioex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                in.close();
            }
            catch (IOException ioex) {
                throw new FBSQLException(ioex);
            }
            try {
                bout.close();
                throw throwable;
            }
            catch (IOException ioex) {
                throw new FBSQLException(ioex);
            }
        }
        try {}
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        in.close();
        try {}
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        bout.close();
        return bout.toByteArray();
    }

    public byte[] getCachedObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return BYTES_NULL_VALUE;
        }
        return this.getBytesInternal();
    }

    public String getString() throws SQLException {
        if (this.field.sqlsubtype < 0) {
            throw (SQLException)FBBlobField.createException(STRING_CONVERSION_ERROR).fillInStackTrace();
        }
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeString(this.getBytes(), this.javaEncoding, this.mappingPath);
    }

    public InputStream getUnicodeStream() throws SQLException {
        return this.getBinaryStream();
    }

    public void setAsciiStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, length);
    }

    public void setCharacterStream(Reader in, int length) throws SQLException {
        if (in == READER_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (!this.c.getAutoCommit()) {
            this.copyCharacterStream(in, length, this.javaEncoding);
        } else {
            char[] buff = new char[4096];
            ByteArrayOutputStream bout = new ByteArrayOutputStream(length);
            try {
                OutputStreamWriter boutw = new OutputStreamWriter((OutputStream)bout, this.javaEncoding);
                try {
                    while (length > 0) {
                        int chunk = in.read(buff, 0, length < 4096 ? length : 4096);
                        boutw.write(buff, 0, chunk);
                        length -= chunk;
                    }
                    boutw.close();
                    bout.close();
                }
                catch (IOException ioe) {
                    throw new FBSQLException(ioe);
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new FBSQLException("Cannot set character stream because the unsupported encoding is detected in the JVM: " + this.javaEncoding + ". Please report this to the driver developers.");
            }
            this.data = bout.toByteArray();
            this.length = this.data.length;
            this.isCachedData = true;
        }
    }

    public void setBinaryStream(InputStream in, int length) throws SQLException {
        if (in == STREAM_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (!this.c.getAutoCommit()) {
            this.copyBinaryStream(in, length);
        } else {
            byte[] buff = new byte[4096];
            ByteArrayOutputStream bout = new ByteArrayOutputStream(length);
            try {
                while (length > 0) {
                    int chunk = in.read(buff, 0, length < 4096 ? length : 4096);
                    bout.write(buff, 0, chunk);
                    length -= chunk;
                }
                bout.close();
            }
            catch (IOException ioe) {
                throw new FBSQLException(ioe);
            }
            this.data = bout.toByteArray();
            this.length = this.data.length;
            this.isCachedData = true;
        }
    }

    public void flushCachedData() throws SQLException {
        if (this.isCachedData) {
            this.copyBinaryStream(new ByteArrayInputStream(this.data), this.length);
            this.isCachedData = false;
        }
    }

    private void copyBinaryStream(InputStream in, int length) throws SQLException {
        if (!this.c.getAutoCommit()) {
            this.c.ensureInTransaction();
        }
        FBBlob blob = new FBBlob(this.c);
        blob.copyStream(in, length);
        this.field.sqldata = this.field.encodeLong(blob.getBlobId());
    }

    private void copyCharacterStream(Reader in, int length, String encoding) throws SQLException {
        if (!this.c.getAutoCommit()) {
            this.c.ensureInTransaction();
        }
        FBBlob blob = new FBBlob(this.c);
        blob.copyCharacterStream(in, length, encoding);
        this.field.sqldata = this.field.encodeLong(blob.getBlobId());
    }

    public void setBytes(byte[] value) throws SQLException {
        if (value == BYTES_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setBinaryStream(new ByteArrayInputStream(value), value.length);
    }

    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setBytes(this.field.encodeString(value, this.javaEncoding, this.mappingPath));
    }

    public void setUnicodeStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, length);
    }

    public void setBlob(FBBlob blob) throws SQLException {
        this.field.sqldata = this.field.encodeLong(blob.getBlobId());
    }
}

