/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Utilities;

public class ScrollWidget
extends Widget {
    private static final int BAR_VERTICAL_SIZE = 16;
    private static final int BAR_HORIZONTAL_SIZE = 16;
    private static final Point POINT_EMPTY = new Point();
    private static final Rectangle RECTANGLE_EMPTY = new Rectangle();
    private static final Border BORDER_RAISED = BorderFactory.createBevelBorder(true);
    private static final Border BORDER_LOWERED = BorderFactory.createBevelBorder(false);
    private Widget viewport;
    private Widget view;
    private SliderWidget verticalSlider;
    private SliderWidget horizontalSlider;
    private Widget upArrow;
    private Widget downArrow;
    private Widget leftArrow;
    private Widget rightArrow;

    public ScrollWidget(Scene scene) {
        super(scene);
        this.setLayout(new ScrollLayout());
        this.setCheckClipping(true);
        this.viewport = new Widget(scene);
        this.viewport.setCheckClipping(true);
        this.addChild(this.viewport);
        this.upArrow = this.createUpArrow();
        this.addChild(this.upArrow);
        this.verticalSlider = this.createVerticalSlider();
        this.addChild(this.verticalSlider);
        this.downArrow = this.createDownArrow();
        this.addChild(this.downArrow);
        this.leftArrow = this.createLeftArrow();
        this.addChild(this.leftArrow);
        this.horizontalSlider = this.createHorizontalSlider();
        this.addChild(this.horizontalSlider);
        this.rightArrow = this.createRightArrow();
        this.addChild(this.rightArrow);
        this.upArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(0, -16)));
        this.downArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(0, 16)));
        this.leftArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(-16, 0)));
        this.rightArrow.getActions().addAction(ActionFactory.createSelectAction(new UnitScrollProvider(16, 0)));
        this.horizontalSlider.getActions().addAction(new BlockScrollAction(this.horizontalSlider, -64, 0));
        this.verticalSlider.getActions().addAction(new BlockScrollAction(this.verticalSlider, 0, -64));
        this.horizontalSlider.getActions().addAction(new SliderAction(this.horizontalSlider));
        this.verticalSlider.getActions().addAction(new SliderAction(this.verticalSlider));
    }

    public ScrollWidget(Scene scene, Widget view) {
        this(scene);
        this.setView(view);
    }

    private SliderWidget createVerticalSlider() {
        return new SliderWidget(this.getScene(), true);
    }

    private SliderWidget createHorizontalSlider() {
        return new SliderWidget(this.getScene(), false);
    }

    private Widget createUpArrow() {
        return new ButtonWidget(this.getScene(), Utilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-up.png"));
    }

    private Widget createDownArrow() {
        return new ButtonWidget(this.getScene(), Utilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-down.png"));
    }

    private Widget createLeftArrow() {
        return new ButtonWidget(this.getScene(), Utilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-left.png"));
    }

    private Widget createRightArrow() {
        return new ButtonWidget(this.getScene(), Utilities.loadImage((String)"org/netbeans/modules/visual/resources/arrow-right.png"));
    }

    public final Widget getView() {
        return this.view;
    }

    public final void setView(Widget view) {
        if (this.view != null) {
            this.viewport.removeChild(this.view);
        }
        this.view = view;
        if (this.view != null) {
            this.viewport.addChild(this.view);
        }
    }

    protected Rectangle calculateClientArea() {
        return new Rectangle(this.calculateSize());
    }

    private Dimension calculateSize() {
        if (this.isPreferredBoundsSet()) {
            Rectangle preferredBounds = this.getPreferredBounds();
            Insets insets = this.getBorder().getInsets();
            return new Dimension(preferredBounds.width - insets.left - insets.right, preferredBounds.height - insets.top - insets.bottom);
        }
        return this.view.getBounds().getSize();
    }

    private void translateView(int dx, int dy) {
        Widget v = this.getView();
        if (v == null) {
            return;
        }
        Point location = this.view.getLocation();
        location.translate(-dx, -dy);
        this.checkViewLocationInBounds(location, this.view, dx, dy);
        v.setPreferredLocation(location);
    }

    private void checkViewLocationInBounds(Point location, Widget v, int dx, int dy) {
        Rectangle view = v.getBounds();
        Rectangle viewport = this.viewport.getBounds();
        if (dx < 0 && location.x > view.x) {
            location.x = view.x;
        }
        if (dy < 0 && location.y > view.y) {
            location.y = view.y;
        }
        if (dx > 0 && location.x + view.width < viewport.x + viewport.width) {
            location.x = viewport.x + viewport.width - view.width;
        }
        if (dy > 0 && location.y + view.height < viewport.y + viewport.height) {
            location.y = viewport.y + viewport.height - view.height;
        }
    }

    private class SliderAction
    extends WidgetAction.Adapter {
        private SliderWidget slider;
        private Widget movingWidget = null;
        private Point dragSceneLocation = null;
        private Point originalSceneLocation = null;

        private SliderAction(SliderWidget slider) {
            this.slider = slider;
        }

        protected boolean isLocked() {
            return this.movingWidget != null;
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            Widget view;
            if (this.isLocked()) {
                return WidgetAction.State.createLocked(widget, this);
            }
            if (event.getButton() == 1 && event.getClickCount() == 1 && (view = ScrollWidget.this.getView()) != null && this.slider.getPartHitAt(event.getPoint()) == SliderWidget.Part.SLIDER) {
                this.movingWidget = widget;
                this.originalSceneLocation = view.getPreferredLocation();
                if (this.originalSceneLocation == null) {
                    this.originalSceneLocation = new Point();
                }
                this.dragSceneLocation = widget.convertLocalToScene(event.getPoint());
                return WidgetAction.State.createLocked(widget, this);
            }
            return WidgetAction.State.REJECTED;
        }

        public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
            boolean state = this.move(widget, event.getPoint());
            if (state) {
                this.movingWidget = null;
            }
            return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        }

        public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
            return this.move(widget, event.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
        }

        private boolean move(Widget widget, Point newLocation) {
            Widget view = ScrollWidget.this.getView();
            if (this.movingWidget != widget || view == null) {
                return false;
            }
            newLocation = widget.convertLocalToScene(newLocation);
            int dx = 0;
            int dy = 0;
            if (this.slider.isVertical()) {
                dy = -((int)((float)(newLocation.y - this.dragSceneLocation.y) / this.slider.getPixelIncrement()));
            } else {
                dx = -((int)((float)(newLocation.x - this.dragSceneLocation.x) / this.slider.getPixelIncrement()));
            }
            newLocation.x = this.originalSceneLocation.x + dx;
            newLocation.y = this.originalSceneLocation.y + dy;
            ScrollWidget.this.checkViewLocationInBounds(newLocation, view, -dx, -dy);
            view.setPreferredLocation(newLocation);
            return true;
        }
    }

    private class BlockScrollAction
    extends WidgetAction.Adapter {
        private SliderWidget slider;
        private int dx;
        private int dy;

        private BlockScrollAction(SliderWidget slider, int dx, int dy) {
            this.slider = slider;
            this.dx = dx;
            this.dy = dy;
        }

        public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
            if (event.getButton() == 1) {
                assert (this.slider == widget);
                SliderWidget.Part part = this.slider.getPartHitAt(event.getPoint());
                switch (part) {
                    case AFTER: {
                        ScrollWidget.this.translateView(-this.dx, -this.dy);
                        return WidgetAction.State.CHAIN_ONLY;
                    }
                    case BEFORE: {
                        ScrollWidget.this.translateView(this.dx, this.dy);
                        return WidgetAction.State.CHAIN_ONLY;
                    }
                }
            }
            return WidgetAction.State.REJECTED;
        }
    }

    private class UnitScrollProvider
    implements SelectProvider {
        private int dx;
        private int dy;

        private UnitScrollProvider(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return true;
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return true;
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            ScrollWidget.this.translateView(this.dx, this.dy);
        }
    }

    private static class SliderWidget
    extends Widget {
        private static final Color COLOR = new Color(5998542);
        private static final Border BORDER = BorderFactory.createBevelBorder(true, COLOR);
        private boolean vertical;
        private long minimumValue = 0L;
        private long maximumValue = 100L;
        private long startValue = 0L;
        private long endValue = 100L;

        private SliderWidget(Scene scene, boolean vertical) {
            super(scene);
            this.vertical = vertical;
            this.setOpaque(true);
            this.setBackground(Color.LIGHT_GRAY);
        }

        public boolean isVertical() {
            return this.vertical;
        }

        public long getMinimumValue() {
            return this.minimumValue;
        }

        public void setValues(long minimumValue, long maximumValue, long startValue, long endValue) {
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
            this.startValue = startValue;
            this.endValue = endValue;
            this.repaint();
        }

        public void setMinimumValue(long minimumValue) {
            this.minimumValue = minimumValue;
            this.repaint();
        }

        public long getMaximumValue() {
            return this.maximumValue;
        }

        public void setMaximumValue(long maximumValue) {
            this.maximumValue = maximumValue;
            this.repaint();
        }

        public long getStartValue() {
            return this.startValue;
        }

        public void setStartValue(long startValue) {
            this.startValue = startValue;
            this.repaint();
        }

        public long getEndValue() {
            return this.endValue;
        }

        public void setEndValue(long endValue) {
            this.endValue = endValue;
            this.repaint();
        }

        public Part getPartHitAt(Point localLocation) {
            int point;
            long area;
            if (!this.isHitAt(localLocation)) {
                return Part.OUTSIDE;
            }
            Rectangle clientArea = this.getClientArea();
            if (this.vertical) {
                area = clientArea.height;
                point = localLocation.y - clientArea.y;
            } else {
                area = clientArea.width;
                point = localLocation.x - clientArea.x;
            }
            long s = Math.min(Math.max(this.startValue, this.minimumValue), this.maximumValue);
            long e = Math.min(Math.max(this.endValue, this.minimumValue), this.maximumValue);
            int start = (int)((float)area * (float)(s - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
            int end = (int)((float)area * (float)(e - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
            if (point < start) {
                return Part.BEFORE;
            }
            if (point >= end) {
                return Part.AFTER;
            }
            return Part.SLIDER;
        }

        public float getPixelIncrement() {
            return (float)(this.vertical ? this.getClientArea().height : this.getClientArea().width) / (float)(this.maximumValue - this.minimumValue);
        }

        protected void paintWidget() {
            long area;
            Graphics2D gr = this.getGraphics();
            Rectangle clientArea = this.getClientArea();
            long l = area = this.vertical ? (long)clientArea.height : (long)clientArea.width;
            if (this.minimumValue < this.maximumValue && this.startValue < this.endValue) {
                long s = Math.min(Math.max(this.startValue, this.minimumValue), this.maximumValue);
                int start = (int)((float)area * (float)(s - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
                long e = Math.min(Math.max(this.endValue, this.minimumValue), this.maximumValue);
                int end = (int)((float)area * (float)(e - this.minimumValue) / (float)(this.maximumValue - this.minimumValue));
                gr.setColor(COLOR);
                if (start + 4 < end) {
                    if (this.vertical) {
                        gr.fillRect(clientArea.x + 2, clientArea.y + start + 2, clientArea.width - 4, end - start - 4);
                        BORDER.paint(gr, new Rectangle(clientArea.x, clientArea.y + start, clientArea.width, end - start));
                    } else {
                        gr.fillRect(clientArea.x + start + 2, clientArea.y + 2, end - start - 4, clientArea.height - 4);
                        BORDER.paint(gr, new Rectangle(clientArea.x + start, clientArea.y, end - start, clientArea.height));
                    }
                } else if (this.vertical) {
                    gr.fillRect(clientArea.x, clientArea.y + start, clientArea.width, end - start);
                } else {
                    gr.fillRect(clientArea.x + start, clientArea.y, end - start, clientArea.height);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Part {
            OUTSIDE,
            BEFORE,
            SLIDER,
            AFTER;

        }
    }

    private static class ButtonWidget
    extends ImageWidget {
        private ButtonWidget(Scene scene, Image image) {
            super(scene, image);
            this.setOpaque(true);
            this.updateAiming(false);
        }

        protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
            if (previousState.isWidgetAimed() != state.isWidgetAimed()) {
                this.updateAiming(state.isWidgetAimed());
            }
        }

        private void updateAiming(boolean state) {
            this.setBackground(state ? Color.GRAY : Color.LIGHT_GRAY);
            this.setBorder(state ? BORDER_LOWERED : BORDER_RAISED);
        }
    }

    private final class ScrollLayout
    implements Layout {
        private ScrollLayout() {
        }

        public void layout(Widget widget) {
            Point scrollWidgetClientAreaLocation;
            if (ScrollWidget.this.isPreferredBoundsSet()) {
                scrollWidgetClientAreaLocation = ScrollWidget.this.getPreferredBounds().getLocation();
                Insets insets = ScrollWidget.this.getBorder().getInsets();
                scrollWidgetClientAreaLocation.translate(insets.left, insets.top);
            } else {
                scrollWidgetClientAreaLocation = new Point();
            }
            Rectangle viewBounds = ScrollWidget.this.view != null ? ScrollWidget.this.view.getPreferredBounds() : new Rectangle();
            Rectangle viewportBounds = ScrollWidget.this.view != null ? new Rectangle(ScrollWidget.this.view.getLocation(), ScrollWidget.this.calculateSize()) : new Rectangle();
            boolean showVertical = this.checkVertical(viewBounds, viewportBounds);
            boolean showHorizontal = this.checkHorizontal(viewBounds, viewportBounds);
            if (showVertical) {
                viewportBounds.width -= 16;
                showHorizontal = this.checkHorizontal(viewBounds, viewportBounds);
            }
            if (showHorizontal) {
                viewportBounds.height -= 16;
                if (!showVertical && (showVertical = this.checkVertical(viewBounds, viewportBounds))) {
                    viewportBounds.width -= 16;
                }
            }
            ScrollWidget.this.viewport.resolveBounds(scrollWidgetClientAreaLocation, new Rectangle(viewportBounds.getSize()));
            int x1 = scrollWidgetClientAreaLocation.x;
            int x2 = scrollWidgetClientAreaLocation.x + viewportBounds.width;
            int y1 = scrollWidgetClientAreaLocation.y;
            int y2 = scrollWidgetClientAreaLocation.y + viewportBounds.height;
            if (showVertical) {
                ScrollWidget.this.upArrow.resolveBounds(new Point(x2, y1), new Rectangle(16, 16));
                ScrollWidget.this.downArrow.resolveBounds(new Point(x2, y2 - 16), new Rectangle(16, 16));
                ScrollWidget.this.verticalSlider.resolveBounds(new Point(x2, y1 + 16), new Rectangle(16, viewportBounds.height - 16 - 16));
            } else {
                ScrollWidget.this.upArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.downArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.verticalSlider.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
            }
            if (showHorizontal) {
                ScrollWidget.this.leftArrow.resolveBounds(new Point(x1, y2), new Rectangle(16, 16));
                ScrollWidget.this.rightArrow.resolveBounds(new Point(x2 - 16, y2), new Rectangle(16, 16));
                ScrollWidget.this.horizontalSlider.resolveBounds(new Point(x1 + 16, y2), new Rectangle(viewportBounds.width - 16 - 16, 16));
            } else {
                ScrollWidget.this.leftArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.rightArrow.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
                ScrollWidget.this.horizontalSlider.resolveBounds(POINT_EMPTY, RECTANGLE_EMPTY);
            }
            ScrollWidget.this.verticalSlider.setValues(viewBounds.y + viewportBounds.y, viewBounds.y + viewportBounds.y + viewBounds.height, 0L, viewportBounds.height);
            ScrollWidget.this.horizontalSlider.setValues(viewBounds.x + viewportBounds.x, viewBounds.x + viewportBounds.x + viewBounds.width, 0L, viewportBounds.width);
        }

        public boolean requiresJustification(Widget widget) {
            return false;
        }

        public void justify(Widget widget) {
        }

        private boolean checkHorizontal(Rectangle viewBounds, Rectangle viewportBounds) {
            return (viewBounds.x < viewportBounds.x || viewBounds.x + viewBounds.width > viewportBounds.x + viewportBounds.width) && viewportBounds.width > 48;
        }

        private boolean checkVertical(Rectangle viewBounds, Rectangle viewportBounds) {
            return (viewBounds.y < viewportBounds.y || viewBounds.y + viewBounds.height > viewportBounds.y + viewportBounds.height) && viewportBounds.height > 48;
        }
    }
}

