/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public final class ObjectSceneRectangularSelectProvider
implements RectangularSelectProvider {
    private ObjectScene scene;

    public ObjectSceneRectangularSelectProvider(ObjectScene scene) {
        this.scene = scene;
    }

    public void performSelection(Rectangle sceneSelection) {
        boolean entirely = sceneSelection.width > 0;
        int w = sceneSelection.width;
        int h = sceneSelection.height;
        Rectangle rect = new Rectangle(w >= 0 ? 0 : w, h >= 0 ? 0 : h, w >= 0 ? w : -w, h >= 0 ? h : -h);
        rect.translate(sceneSelection.x, sceneSelection.y);
        HashSet set = new HashSet();
        Set<?> objects = this.scene.getObjects();
        for (Object object : objects) {
            Rectangle widgetRect;
            Widget widget = this.scene.findWidget(object);
            if (widget == null) continue;
            if (entirely) {
                widgetRect = widget.convertLocalToScene(widget.getBounds());
                if (!rect.contains(widgetRect)) continue;
                set.add(object);
                continue;
            }
            if (widget instanceof ConnectionWidget) {
                ConnectionWidget conn = (ConnectionWidget)widget;
                List<Point> points = conn.getControlPoints();
                for (int i = points.size() - 2; i >= 0; --i) {
                    Point p2;
                    Point p1 = widget.convertLocalToScene(points.get(i));
                    if (!new Line2D.Float(p1, p2 = widget.convertLocalToScene(points.get(i + 1))).intersects(rect)) continue;
                    set.add(object);
                }
                continue;
            }
            widgetRect = widget.convertLocalToScene(widget.getBounds());
            if (!rect.intersects(widgetRect)) continue;
            set.add(object);
        }
        Iterator iterator = set.iterator();
        this.scene.setFocusedObject(iterator.hasNext() ? iterator.next() : null);
        this.scene.userSelectionSuggested(set, false);
    }
}

