/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Point;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.model.StateModel;
import org.netbeans.api.visual.widget.Widget;

public final class ProxyAnchor
extends Anchor
implements StateModel.Listener {
    private StateModel model;
    private Anchor[] anchors;
    private int index;

    public ProxyAnchor(StateModel model, Anchor ... anchors) {
        super(null);
        this.model = model;
        this.anchors = anchors;
        this.index = model.getState();
    }

    public StateModel getModel() {
        return this.model;
    }

    protected void notifyEntryAdded(Anchor.Entry entry) {
        this.anchors[this.index].addEntry(entry);
    }

    protected void notifyEntryRemoved(Anchor.Entry entry) {
        this.anchors[this.index].removeEntry(entry);
    }

    protected void notifyUsed() {
        this.model.addListener(this);
    }

    protected void notifyUnused() {
        this.model.removeListener(this);
    }

    public void stateChanged() {
        int state = this.getModel().getState();
        if (this.index == state) {
            return;
        }
        this.anchors[this.index].removeEntries(this.getEntries());
        this.index = state;
        this.anchors[this.index].addEntries(this.getEntries());
        this.revalidateDependency();
    }

    public Point getRelatedSceneLocation() {
        return this.anchors[this.index].getRelatedSceneLocation();
    }

    public Widget getRelatedWidget() {
        return this.anchors[this.index].getRelatedWidget();
    }

    public Anchor.Result compute(Anchor.Entry entry) {
        return this.anchors[this.index].compute(entry);
    }
}

