/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.QuickMenuItem;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.services.desktop.DesktopUtils;
import com.opera.core.systems.scope.services.desktop.SystemInput;
import java.util.ArrayList;
import java.util.List;

public class QuickMenu {
    private final DesktopWmProtos.QuickMenuInfo info;
    private final DesktopUtils desktopUtils;
    private final SystemInput systemInputManager;

    public QuickMenu(DesktopWmProtos.QuickMenuInfo info, DesktopUtils desktopUtils, SystemInput inputManager) {
        this.info = info;
        this.desktopUtils = desktopUtils;
        this.systemInputManager = inputManager;
    }

    public String getName() {
        return this.info.getMenuId().getMenuName();
    }

    public boolean isVisible() {
        return true;
    }

    public int getParentWindowId() {
        return this.info.getWindowId().getWindowID();
    }

    public List<QuickMenuItem> getItemList() {
        ArrayList<QuickMenuItem> itemList = new ArrayList<QuickMenuItem>();
        for (DesktopWmProtos.QuickMenuItemInfo itemInfo : this.info.getMenuItemListList()) {
            QuickMenuItem item = new QuickMenuItem(itemInfo, this.getName(), this.desktopUtils, this.systemInputManager);
            itemList.add(item);
        }
        return itemList;
    }

    public boolean hasSubmenu() {
        List<QuickMenuItem> items = this.getItemList();
        for (QuickMenuItem item : items) {
            if (!item.hasSubMenu()) continue;
            return true;
        }
        return false;
    }

    public DesktopWmProtos.DesktopWindowRect getRect() {
        return this.info.getRect();
    }

    public String toString() {
        return "QuickMenu " + this.getName();
    }

    public String toFullString() {
        return "QuickMenu\n       Menu name: " + this.getName() + "\n" + "          x: " + this.getRect().getX() + "\n" + "          y: " + this.getRect().getY() + "\n" + "      width: " + this.getRect().getWidth() + "\n" + "     height: " + this.getRect().getHeight() + " \n";
    }
}

