/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.internal.CircularOutputStream;

@Beta
public class MarionetteConnection
implements ExtensionConnection,
NeedsLocalLogs {
    private static final int BUFFER_SIZE = 4096;
    private final long connectTimeout;
    private final FirefoxBinary process;
    private final FirefoxProfile profile;
    private final String host;
    private final Lock lock;
    private File profileDir;
    private static Map<String, String> seleniumToMarionetteCommandMap = ImmutableMap.builder().put("get", "goUrl").put("getCurrentWindowHandle", "getWindow").put("getWindowHandles", "getWindows").put("close", "closeWindow").put("getCurrentUrl", "getUrl").put("findChildElement", "findElement").put("findChildElements", "findElements").put("getElementLocation", "getElementPosition").put("getCookies", "getAllCookies").put("quit", "deleteSession").build();
    private Socket socket;
    private PrintWriter writer;
    private Reader reader;
    private String marionetteId;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public MarionetteConnection(Lock lock, FirefoxBinary binary, FirefoxProfile profile, String host) throws Exception {
        this.host = host;
        this.connectTimeout = binary.getTimeout();
        this.lock = lock;
        this.profile = profile;
        this.process = binary;
    }

    @Override
    public void start() throws IOException {
        int port = 2828;
        this.profile.setPreference("marionette.defaultPrefs.enabled", true);
        this.profile.setPreference("marionette.defaultPrefs.port", 2828);
        this.profile.setPreference("browser.warnOnQuit", false);
        this.lock.lock(this.connectTimeout);
        try {
            try {
                this.profileDir = this.profile.layoutOnDisk();
                this.process.clean(this.profile, this.profileDir);
                String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
                if (firefoxLogFile != null) {
                    if ("/dev/stdout".equals(firefoxLogFile)) {
                        this.process.setOutputWatcher(System.out);
                    } else {
                        File logFile = new File(firefoxLogFile);
                        this.process.setOutputWatcher(new CircularOutputStream(logFile, 4096));
                    }
                }
                this.process.startProfile(this.profile, this.profileDir, "-foreground", "-marionette");
                Thread.sleep(5000L);
                long waitUntil = System.currentTimeMillis() + this.connectTimeout;
                while (!this.isConnected()) {
                    this.tryToConnect(this.host, port);
                    if (waitUntil < System.currentTimeMillis()) {
                        throw new Error("Can't connect to " + this.host + ":" + port + "\n" + this.process.getConsoleOutput());
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), port, this.process.getConsoleOutput()), e);
            }
            catch (WebDriverException e) {
                throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), port, this.process.getConsoleOutput()), e);
            }
            catch (Exception e) {
                throw new WebDriverException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.receiveResponse();
        this.sendCommand(this.serializeCommand(new Command(null, "getMarionetteID")));
        String getMarionetteIdRawResponse = this.receiveResponse();
        Map map = new JsonToBeanConverter().convert(Map.class, getMarionetteIdRawResponse);
        this.marionetteId = map.get("id").toString();
    }

    private void tryToConnect(String host, int port) {
        try {
            this.socket = new Socket(host, port);
            this.writer = new PrintWriter(this.socket.getOutputStream(), true);
            this.reader = new InputStreamReader(this.socket.getInputStream());
        }
        catch (ConnectException connectException) {
            this.socket = null;
            this.writer = null;
            this.reader = null;
        }
        catch (IOException iOException) {
            this.socket = null;
            this.writer = null;
            this.reader = null;
        }
    }

    @Override
    public Response execute(Command command) throws IOException {
        Response response;
        String commandAsString = this.serializeCommand(command);
        this.sendCommand(commandAsString);
        String rawResponse = this.receiveResponse();
        Map map = new JsonToBeanConverter().convert(Map.class, rawResponse);
        if ("newSession".equals(command.getName())) {
            response = new Response(new SessionId(map.get("value").toString()));
            response.setValue(Maps.newHashMap());
        } else if (map.containsKey("error")) {
            response = new Response();
            Map errorMap = (Map)map.get("error");
            if (errorMap != null) {
                response.setStatus(Integer.parseInt(errorMap.get("status").toString()));
                errorMap.remove("status");
                response.setValue(errorMap);
            }
        } else {
            response = new JsonToBeanConverter().convert(Response.class, rawResponse);
            if (("findElement".equals(command.getName()) || "findChildElement".equals(command.getName()) || "getActiveElement".equals(command.getName())) && response.getStatus() == 0) {
                HashMap<String, String> wrappedElement = Maps.newHashMap();
                wrappedElement.put("ELEMENT", response.getValue().toString());
                response.setValue(wrappedElement);
            }
            if (("findElements".equals(command.getName()) || "findChildElements".equals(command.getName())) && response.getStatus() == 0) {
                ArrayList wrapped = Lists.newArrayList();
                List elementIds = (List)response.getValue();
                for (Object elementId : elementIds) {
                    HashMap<String, String> wrappedElement = Maps.newHashMap();
                    wrappedElement.put("ELEMENT", elementId.toString());
                    wrapped.add(wrappedElement);
                }
                response.setValue(wrapped);
            }
        }
        return response;
    }

    private String serializeCommand(Command command) {
        String commandName = command.getName();
        HashMap<String, Object> params = Maps.newHashMap();
        params.putAll(command.getParameters());
        if ("newSession".equals(commandName)) {
            params.remove("desiredCapabilities");
        } else if ("get".equals(commandName)) {
            this.renameParameter(params, "url", "value");
        } else if ("setTimeout".equals(commandName)) {
            String timeoutType = (String)params.get("type");
            if ("implicit".equals(timeoutType)) {
                commandName = "setSearchTimeout";
            } else if ("script".equals(timeoutType)) {
                commandName = "setScriptTimeout";
            }
            params.remove("type");
            this.renameParameter(params, "ms", "value");
        } else if ("executeScript".equals(commandName) || "executeAsyncScript".equals(commandName)) {
            this.renameParameter(params, "script", "value");
        } else if ("switchToWindow".equals(commandName)) {
            this.renameParameter(params, "name", "value");
        } else if ("switchToFrame".equals(commandName)) {
            Object target = params.get("id");
            if (target instanceof Map) {
                String elementId = (String)((Map)target).get("ELEMENT");
                params.put("element", elementId);
                params.remove("id");
            } else {
                this.renameParameter(params, "id", "value");
            }
        } else if ("findChildElement".equals(commandName) || "findChildElements".equals(commandName) || "clickElement".equals(commandName) || "clearElement".equals(commandName) || "getElementAttribute".equals(commandName) || "getElementText".equals(commandName) || "sendKeysToElement".equals(commandName) || "isElementSelected".equals(commandName) || "isElementEnabled".equals(commandName) || "isElementDisplayed".equals(commandName) || "getElementSize".equals(commandName) || "getElementLocation".equals(commandName) || "getElementTagName".equals(commandName)) {
            this.renameParameter(params, "id", "element");
        } else if ("mouseClick".equals(commandName) || "mouseDoubleClick".equals(commandName) || "mouseButtonDown".equals(commandName) || "mouseButtonUp".equals(commandName) || "mouseMoveTo".equals(commandName)) {
            String actionName = commandName;
            commandName = "actionChain";
            ArrayList<String> action = Lists.newArrayList();
            action.add(actionName);
            if (params.containsKey("element")) {
                action.add((String)params.get("element"));
                params.remove("element");
            }
            ArrayList<ArrayList<String>> actions2 = Lists.newArrayList();
            actions2.add(action);
            params.put("chain", actions2);
        }
        if (seleniumToMarionetteCommandMap.containsKey(commandName)) {
            commandName = seleniumToMarionetteCommandMap.get(commandName);
        }
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("to", this.marionetteId != null ? this.marionetteId : "root");
        map.put("type", commandName);
        if (command.getSessionId() != null) {
            map.put("session", command.getSessionId().toString());
        }
        map.putAll(params);
        return new BeanToJsonConverter().convert(map);
    }

    private void renameParameter(Map<String, Object> params, String origParName, String newParName) {
        Object o = params.get(origParName);
        params.put(newParName, o);
        params.remove(origParName);
    }

    private void sendCommand(String commandAsString) {
        String line = commandAsString.length() + ":" + commandAsString + " ";
        this.writer.write(line);
        this.writer.flush();
    }

    private String receiveResponse() throws IOException {
        StringBuilder response = new StringBuilder();
        char[] buf = new char[1024];
        int len = this.reader.read(buf);
        response.append(buf, 0, len);
        while (len >= 1024) {
            buf = new char[1024];
            len = this.reader.read(buf);
            response.append(buf, 0, len);
        }
        String[] parts = response.toString().split(":", 2);
        int length = Integer.parseInt(parts[0]);
        return parts[1].substring(0, length);
    }

    @Override
    public void quit() {
        try {
            this.writer.close();
            this.reader.close();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.socket = null;
        this.process.quit();
        if (this.profileDir != null) {
            this.profile.clean(this.profileDir);
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }
}

