/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.iphone;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.iphone.IPhoneSimulatorBinary;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;

@Deprecated
public class IPhoneSimulatorCommandExecutor
implements CommandExecutor {
    private static final Logger LOG = Logger.getLogger(IPhoneSimulatorCommandExecutor.class.getName());
    private final CommandExecutor delegate;
    private final IPhoneSimulatorBinary binary;
    private final URL appUrl;

    public IPhoneSimulatorCommandExecutor(URL url, IPhoneSimulatorBinary binary) throws Exception {
        this.delegate = new HttpCommandExecutor(url);
        this.binary = binary;
        this.appUrl = url;
    }

    @VisibleForTesting
    IPhoneSimulatorBinary getBinary() {
        return this.binary;
    }

    public void startClient() {
        this.binary.launch();
        this.waitForServerToRespond(2500L);
    }

    private void waitForServerToRespond(long timeoutInMilliseconds) {
        long start = System.currentTimeMillis();
        boolean responding = false;
        while (!responding && System.currentTimeMillis() - start < timeoutInMilliseconds) {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)this.appUrl.openConnection();
                connection.setConnectTimeout(500);
                connection.setRequestMethod("TRACE");
                connection.connect();
                responding = true;
            }
            catch (ProtocolException protocolException) {
                responding = false;
                if (connection == null) continue;
                connection.disconnect();
                continue;
            }
            catch (IOException iOException) {
                try {
                    responding = false;
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
            if (connection == null) continue;
            connection.disconnect();
        }
    }

    public void stopClient() {
        this.binary.shutdown();
    }

    @Override
    public Response execute(Command command) throws IOException {
        if (!this.binary.isRunning()) {
            throw new IPhoneSimulatorNotRunningException();
        }
        try {
            return this.delegate.execute(command);
        }
        catch (ConnectException e) {
            LOG.log(Level.WARNING, "Connection refused?", e);
            if (!this.binary.isRunning()) {
                throw new IPhoneSimulatorNotRunningException("The iPhone Simulator died!", e);
            }
            throw e;
        }
    }

    public static class IPhoneSimulatorNotRunningException
    extends WebDriverException {
        public IPhoneSimulatorNotRunningException() {
            super("The iPhone Simulator is not currently running!");
        }

        public IPhoneSimulatorNotRunningException(Throwable cause) {
            super("The iPhone Simulator is not currently running!", cause);
        }

        public IPhoneSimulatorNotRunningException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

