/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.resource.Location;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscUtil {
    public static String toSimpleMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName() + "(");
        Class<?>[] params = method.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(MiscUtil.getTypeName(params[j]));
            if (j >= params.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static <T> T newInstanceFromProperty(String key, String def, Class<T> type) {
        String clz = Library.getProperty((String)key, (String)def);
        if (clz != null) {
            Object v;
            try {
                v = Classes.newInstanceByThread((String)clz);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
            if (!type.isAssignableFrom(v.getClass())) {
                throw new UiException(type + " must be implemented by " + v);
            }
            return (T)v;
        }
        return null;
    }

    public static String formatLocationMessage(String message, Object obj) {
        if (obj == null) {
            return message;
        }
        if (obj instanceof Component) {
            return MiscUtil.formatLocationMessage(message, (Component)obj);
        }
        if (obj instanceof Annotation) {
            return MiscUtil.formatLocationMessage(message, (Annotation)obj);
        }
        if (obj instanceof Location) {
            return MiscUtil.formatLocationMessage(message, (Location)obj);
        }
        return MiscUtil.formatLocationMessage(message, (Location)null);
    }

    public static String formatLocationMessage(String message, Component comp) {
        if (comp == null) {
            return message;
        }
        return MiscUtil.formatLocationMessage(message, MiscUtil.toComponentLocation(comp), false);
    }

    private static Location toComponentLocation(Component comp) {
        if (comp instanceof AbstractComponent) {
            Annotation anno = ((AbstractComponent)comp).getAnnotation(null, "ZKLOC");
            return anno == null ? null : anno.getLocation();
        }
        return null;
    }

    public static String formatLocationMessage(String message, Annotation anno) {
        if (anno == null) {
            return message;
        }
        return MiscUtil.formatLocationMessage(message, anno.getLocation(), true);
    }

    public static String formatLocationMessage(String message, Location loc) {
        return MiscUtil.formatLocationMessage(message, loc, true);
    }

    private static String formatLocationMessage(String message, Location loc, boolean showColumn) {
        if (loc == null) {
            return message;
        }
        String path = loc.getPath();
        int ln = loc.getLineNumber();
        int cn = loc.getColumnNumber();
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message);
        }
        sb.append(" at [").append(path);
        if (ln >= 0) {
            sb.append(", line:").append(ln);
            if (showColumn && cn >= 0) {
                sb.append(", nearby column: ").append(cn);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static RuntimeException mergeExceptionInfo(Exception ex, Object loc) {
        Location location = null;
        boolean showColumn = true;
        if (loc instanceof Component) {
            location = MiscUtil.toComponentLocation((Component)loc);
            showColumn = false;
        } else if (loc instanceof Annotation) {
            location = ((Annotation)loc).getLocation();
        } else if (loc instanceof Location) {
            location = (Location)loc;
        }
        if (location == null) {
            if (ex instanceof RuntimeException) {
                return (RuntimeException)ex;
            }
            return new UiException(ex.getMessage(), (Throwable)ex);
        }
        String orgMsg = ex.getMessage();
        String msg = MiscUtil.formatLocationMessage(null, location, showColumn);
        if (orgMsg != null && orgMsg.endsWith(msg)) {
            if (ex instanceof RuntimeException) {
                return (RuntimeException)ex;
            }
            return new UiException(ex.getMessage(), (Throwable)ex);
        }
        msg = MiscUtil.formatLocationMessage(orgMsg, location, showColumn);
        return new UiException(msg, (Throwable)ex);
    }
}

