/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.ancestor;

import java.util.List;
import java.util.Locale;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.outerj.daisy.diff.html.ancestor.AncestorComparatorResult;
import org.outerj.daisy.diff.html.ancestor.ChangeTextGenerator;
import org.outerj.daisy.diff.html.dom.TagNode;

public class AncestorComparator
implements IRangeComparator {
    private List<TagNode> ancestors;
    private String compareTxt = "";

    public AncestorComparator(List<TagNode> list) {
        this.ancestors = list;
    }

    @Override
    public int getRangeCount() {
        return this.ancestors.size();
    }

    @Override
    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        AncestorComparator ancestorComparator;
        try {
            ancestorComparator = (AncestorComparator)iRangeComparator;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return ancestorComparator.getAncestor(n2).isSameTag(this.getAncestor(n));
    }

    @Override
    public boolean skipRangeComparison(int n, int n2, IRangeComparator iRangeComparator) {
        return false;
    }

    public TagNode getAncestor(int n) {
        return this.ancestors.get(n);
    }

    public String getCompareTxt() {
        return this.compareTxt;
    }

    public AncestorComparatorResult getResult(AncestorComparator ancestorComparator, Locale locale) {
        AncestorComparatorResult ancestorComparatorResult = new AncestorComparatorResult();
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(ancestorComparator, this);
        if (rangeDifferenceArray.length == 0) {
            return ancestorComparatorResult;
        }
        ChangeTextGenerator changeTextGenerator = new ChangeTextGenerator(this, ancestorComparator, locale);
        ancestorComparatorResult.setChanged(true);
        ancestorComparatorResult.setChanges(changeTextGenerator.getChanged(rangeDifferenceArray).toString());
        ancestorComparatorResult.setHtmlLayoutChanges(changeTextGenerator.getHtmlLayoutChanges());
        return ancestorComparatorResult;
    }
}

