/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class TypeAdapter {
    public Object target;
    public Fixture fixture;
    public Field field;
    public Method method;
    public Class<?> type;
    public boolean isRegex;
    private static Map<Class<?>, TypeAdapter> PARSE_DELEGATES = new HashMap();

    public static TypeAdapter on(Fixture target, Class<?> type) {
        TypeAdapter a = TypeAdapter.adapterFor(type);
        a.init(target, type);
        return a;
    }

    public static TypeAdapter on(Fixture fixture, Field field) {
        TypeAdapter a = TypeAdapter.on(fixture, field.getType());
        a.target = fixture;
        a.field = field;
        return a;
    }

    public static TypeAdapter on(Fixture fixture, Method method) {
        return TypeAdapter.on(fixture, method, false);
    }

    public static TypeAdapter on(Fixture fixture, Method method, boolean isRegex) {
        TypeAdapter a = TypeAdapter.on(fixture, method.getReturnType());
        a.target = fixture;
        a.method = method;
        a.isRegex = isRegex;
        return a;
    }

    public static TypeAdapter adapterFor(Class<?> type) throws UnsupportedOperationException {
        if (type.isPrimitive()) {
            if (type.equals(Byte.TYPE)) {
                return new ByteAdapter();
            }
            if (type.equals(Short.TYPE)) {
                return new ShortAdapter();
            }
            if (type.equals(Integer.TYPE)) {
                return new IntAdapter();
            }
            if (type.equals(Long.TYPE)) {
                return new LongAdapter();
            }
            if (type.equals(Float.TYPE)) {
                return new FloatAdapter();
            }
            if (type.equals(Double.TYPE)) {
                return new DoubleAdapter();
            }
            if (type.equals(Character.TYPE)) {
                return new CharAdapter();
            }
            if (type.equals(Boolean.TYPE)) {
                return new BooleanAdapter();
            }
            throw new UnsupportedOperationException("can't yet adapt " + type);
        }
        TypeAdapter delegate = PARSE_DELEGATES.get(type);
        if (delegate instanceof DelegateClassAdapter) {
            return (TypeAdapter)((DelegateClassAdapter)delegate).clone();
        }
        if (delegate instanceof DelegateObjectAdapter) {
            return (TypeAdapter)((DelegateObjectAdapter)delegate).clone();
        }
        if (type.equals(Byte.class)) {
            return new ClassByteAdapter();
        }
        if (type.equals(Short.class)) {
            return new ClassShortAdapter();
        }
        if (type.equals(Integer.class)) {
            return new ClassIntegerAdapter();
        }
        if (type.equals(Long.class)) {
            return new ClassLongAdapter();
        }
        if (type.equals(Float.class)) {
            return new ClassFloatAdapter();
        }
        if (type.equals(Double.class)) {
            return new ClassDoubleAdapter();
        }
        if (type.equals(Character.class)) {
            return new ClassCharacterAdapter();
        }
        if (type.equals(Boolean.class)) {
            return new ClassBooleanAdapter();
        }
        if (type.isArray()) {
            return new ArrayAdapter();
        }
        return new TypeAdapter();
    }

    public void init(Fixture fixture2, Class<?> type2) {
        this.fixture = fixture2;
        this.type = type2;
    }

    public Object get() throws IllegalAccessException, InvocationTargetException {
        if (this.field != null) {
            return this.field.get(this.target);
        }
        if (this.method != null) {
            return this.invoke();
        }
        return null;
    }

    public void set(Object value) throws Exception {
        this.field.set(this.target, value);
    }

    public Object invoke() throws IllegalAccessException, InvocationTargetException {
        Object[] params = new Object[]{};
        return this.method.invoke(this.target, params);
    }

    public Object parse(String s) throws Exception {
        String obj = this.isRegex ? s : this.fixture.parse(s, this.type);
        return obj;
    }

    public boolean equals(Object a, Object b) {
        boolean isEqual = false;
        isEqual = this.isRegex ? Pattern.matches(a.toString(), b.toString()) : (a == null ? b == null : a.equals(b));
        return isEqual;
    }

    public String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String && ((String)o).equals("")) {
            return "blank";
        }
        return o.toString();
    }

    public static void registerParseDelegate(Class<?> type, Class<?> parseDelegate) {
        try {
            PARSE_DELEGATES.put(type, new DelegateClassAdapter(parseDelegate));
        }
        catch (Exception ex) {
            throw new RuntimeException("Parse delegate class " + parseDelegate.getName() + " does not have a suitable static parse() method.");
        }
    }

    public static void registerParseDelegate(Class<?> type, Object parseDelegate) {
        try {
            PARSE_DELEGATES.put(type, new DelegateObjectAdapter(parseDelegate));
        }
        catch (Exception ex) {
            throw new RuntimeException("Parse delegate object of class " + parseDelegate.getClass().getName() + " does not have a suitable parse() method.");
        }
    }

    public static void clearDelegatesForNextTest() {
        PARSE_DELEGATES.clear();
    }

    static class DelegateObjectAdapter
    extends TypeAdapter
    implements Cloneable {
        private Object delegate;
        private Method parseMethod;

        public DelegateObjectAdapter(Object delegate) throws SecurityException, NoSuchMethodException {
            this.delegate = delegate;
            this.parseMethod = delegate.getClass().getMethod("parse", String.class);
        }

        @Override
        public Object parse(String s) throws Exception {
            return this.parseMethod.invoke(this.delegate, s);
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    static class DelegateClassAdapter
    extends TypeAdapter
    implements Cloneable {
        private Method parseMethod;

        public DelegateClassAdapter(Class<?> parseDelegate) throws SecurityException, NoSuchMethodException {
            this.parseMethod = parseDelegate.getMethod("parse", String.class);
            int modifiers = this.parseMethod.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || this.parseMethod.getReturnType() == Void.class) {
                throw new NoSuchMethodException();
            }
        }

        @Override
        public Object parse(String s) throws Exception {
            return this.parseMethod.invoke(null, s);
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    static class ArrayAdapter
    extends TypeAdapter {
        Class<?> componentType;
        TypeAdapter componentAdapter;

        ArrayAdapter() {
        }

        @Override
        public void init(Fixture target2, Class<?> type2) {
            super.init(target2, type2);
            this.componentType = type2.getComponentType();
            this.componentAdapter = ArrayAdapter.on(target2, this.componentType);
        }

        @Override
        public Object parse(String s) throws Exception {
            StringTokenizer t = new StringTokenizer(s, ",");
            Object array = Array.newInstance(this.componentType, t.countTokens());
            int i = 0;
            while (t.hasMoreTokens()) {
                Array.set(array, i, this.componentAdapter.parse(t.nextToken().trim()));
                ++i;
            }
            return array;
        }

        @Override
        public String toString(Object o) {
            if (o == null) {
                return "";
            }
            int length = Array.getLength(o);
            StringBuffer b = new StringBuffer(5 * length);
            for (int i = 0; i < length; ++i) {
                b.append(this.componentAdapter.toString(Array.get(o, i)));
                if (i >= length - 1) continue;
                b.append(", ");
            }
            return b.toString();
        }

        @Override
        public boolean equals(Object a, Object b) {
            int length = Array.getLength(a);
            if (length != Array.getLength(b)) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (this.componentAdapter.equals(Array.get(a, i), Array.get(b, i))) continue;
                return false;
            }
            return true;
        }
    }

    static class ClassBooleanAdapter
    extends TypeAdapter {
        ClassBooleanAdapter() {
        }

        @Override
        public Object parse(String s) {
            if ("null".equals(s)) {
                return null;
            }
            String ls = s.toLowerCase();
            if (ls.equals("true")) {
                return new Boolean(true);
            }
            if (ls.equals("yes")) {
                return new Boolean(true);
            }
            if (ls.equals("1")) {
                return new Boolean(true);
            }
            if (ls.equals("y")) {
                return new Boolean(true);
            }
            if (ls.equals("+")) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
    }

    static class BooleanAdapter
    extends ClassBooleanAdapter {
        BooleanAdapter() {
        }

        @Override
        public void set(Object i) throws IllegalAccessException {
            this.field.setBoolean(this.target, (Boolean)i);
        }
    }

    static class ClassCharacterAdapter
    extends TypeAdapter {
        ClassCharacterAdapter() {
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Character(s.charAt(0));
        }
    }

    static class CharAdapter
    extends ClassCharacterAdapter {
        CharAdapter() {
        }

        @Override
        public void set(Object i) throws IllegalAccessException {
            this.field.setChar(this.target, ((Character)i).charValue());
        }
    }

    static class ClassDoubleAdapter
    extends TypeAdapter {
        ClassDoubleAdapter() {
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Double(Double.parseDouble(s));
        }
    }

    static class DoubleAdapter
    extends ClassDoubleAdapter {
        DoubleAdapter() {
        }

        @Override
        public void set(Object i) throws IllegalAccessException {
            this.field.setDouble(this.target, ((Number)i).doubleValue());
        }

        @Override
        public Object parse(String s) {
            return new Double(Double.parseDouble(s));
        }
    }

    static class ClassFloatAdapter
    extends TypeAdapter {
        ClassFloatAdapter() {
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Float(Float.parseFloat(s));
        }
    }

    static class FloatAdapter
    extends ClassFloatAdapter {
        FloatAdapter() {
        }

        @Override
        public void set(Object i) throws IllegalAccessException {
            this.field.setFloat(this.target, ((Number)i).floatValue());
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Float(Float.parseFloat(s));
        }
    }

    static class ClassLongAdapter
    extends TypeAdapter {
        ClassLongAdapter() {
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Long(Long.parseLong(s));
        }
    }

    static class LongAdapter
    extends ClassLongAdapter {
        LongAdapter() {
        }

        public void set(Long i) throws IllegalAccessException {
            this.field.setLong(this.target, i);
        }
    }

    static class ClassIntegerAdapter
    extends TypeAdapter {
        ClassIntegerAdapter() {
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Integer(Integer.parseInt(s));
        }
    }

    static class IntAdapter
    extends ClassIntegerAdapter {
        IntAdapter() {
        }

        @Override
        public void set(Object i) throws IllegalAccessException {
            this.field.setInt(this.target, (Integer)i);
        }
    }

    static class ClassShortAdapter
    extends TypeAdapter {
        ClassShortAdapter() {
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Short(Short.parseShort(s));
        }
    }

    static class ShortAdapter
    extends ClassShortAdapter {
        ShortAdapter() {
        }

        @Override
        public void set(Object i) throws IllegalAccessException {
            this.field.setShort(this.target, (Short)i);
        }
    }

    static class ClassByteAdapter
    extends TypeAdapter {
        ClassByteAdapter() {
        }

        @Override
        public Object parse(String s) {
            return "null".equals(s) ? null : new Byte(Byte.parseByte(s));
        }
    }

    static class ByteAdapter
    extends ClassByteAdapter {
        ByteAdapter() {
        }

        @Override
        public void set(Object i) throws IllegalAccessException {
            this.field.setByte(this.target, (Byte)i);
        }
    }
}

