/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.ColumnFixture;
import fit.Fixture;
import fit.TypeAdapter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class TypeAdapterTest
extends TestCase {
    private TestFixture f = new TestFixture();
    private TypeAdapter adapter;
    private static final String dateFormat = "MMM dd yyyy";

    public void testTypeAdapter() throws Exception {
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleInt"));
        this.adapter.set(this.adapter.parse("123456"));
        TypeAdapterTest.assertEquals((int)123456, (int)this.f.sampleInt);
        TypeAdapterTest.assertEquals((String)"-234567", (String)this.adapter.parse("-234567").toString());
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleInteger"));
        this.adapter.set(this.adapter.parse("54321"));
        TypeAdapterTest.assertEquals((String)"54321", (String)this.f.sampleInteger.toString());
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getMethod("pi", new Class[0]));
        TypeAdapterTest.assertEquals((double)3.14159, (double)((Double)this.adapter.invoke()), (double)1.0E-5);
        TypeAdapterTest.assertEquals((Object)new Double(3.141592653), (Object)this.adapter.invoke());
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("ch"));
        this.adapter.set(this.adapter.parse("abc"));
        TypeAdapterTest.assertEquals((char)'a', (char)this.f.ch);
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("name"));
        this.adapter.set(this.adapter.parse("xyzzy"));
        TypeAdapterTest.assertEquals((String)"xyzzy", (String)this.f.name);
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleFloat"));
        this.adapter.set(this.adapter.parse("6.02e23"));
        TypeAdapterTest.assertEquals((double)6.02E23, (double)this.f.sampleFloat, (double)1.0E17);
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleArray"));
        this.adapter.set(this.adapter.parse("1,2,3"));
        TypeAdapterTest.assertEquals((int)1, (int)this.f.sampleArray[0]);
        TypeAdapterTest.assertEquals((int)2, (int)this.f.sampleArray[1]);
        TypeAdapterTest.assertEquals((int)3, (int)this.f.sampleArray[2]);
        TypeAdapterTest.assertEquals((String)"1, 2, 3", (String)this.adapter.toString(this.f.sampleArray));
        TypeAdapterTest.assertTrue((boolean)this.adapter.equals(new int[]{1, 2, 3}, this.f.sampleArray));
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleDate"));
        Date date = new GregorianCalendar(1949, 4, 26).getTime();
        String format = DateFormat.getDateInstance(3).format(date);
        this.adapter.set(this.adapter.parse(format));
        TypeAdapterTest.assertEquals((Object)date, (Object)this.f.sampleDate);
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleByte"));
        this.adapter.set(this.adapter.parse("123"));
        TypeAdapterTest.assertEquals((int)123, (int)this.f.sampleByte);
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleShort"));
        this.adapter.set(this.adapter.parse("12345"));
        TypeAdapterTest.assertEquals((int)12345, (int)this.f.sampleShort);
    }

    public void testBooleanTypeAdapter() throws Exception {
        this.assertBooleanTypeAdapterParses("true", true);
        this.assertBooleanTypeAdapterParses("yes", true);
        this.assertBooleanTypeAdapterParses("y", true);
        this.assertBooleanTypeAdapterParses("+", true);
        this.assertBooleanTypeAdapterParses("1", true);
        this.assertBooleanTypeAdapterParses("True", true);
        this.assertBooleanTypeAdapterParses("YES", true);
        this.assertBooleanTypeAdapterParses("Y", true);
        this.assertBooleanTypeAdapterParses("N", false);
        this.assertBooleanTypeAdapterParses("No", false);
        this.assertBooleanTypeAdapterParses("false", false);
        this.assertBooleanTypeAdapterParses("0", false);
        this.assertBooleanTypeAdapterParses("-", false);
        this.assertBooleanTypeAdapterParses("whatever", false);
    }

    private void assertBooleanTypeAdapterParses(String booleanString, boolean assertedValue) throws Exception {
        TypeAdapter booleanAdapter = TypeAdapter.adapterFor(Boolean.class);
        Boolean result = (Boolean)booleanAdapter.parse(booleanString);
        TypeAdapterTest.assertTrue((result == assertedValue ? 1 : 0) != 0);
    }

    public void testParseDelegateObjectMethod() throws Exception {
        Date april26Of1949 = new GregorianCalendar(1949, 4, 26).getTime();
        String format = new SimpleDateFormat(dateFormat).format(april26Of1949);
        TypeAdapter.registerParseDelegate(Date.class, new SimpleDateFormat(dateFormat));
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleDate"));
        this.adapter.set(this.adapter.parse(format));
        TypeAdapterTest.assertEquals((Object)april26Of1949, (Object)this.f.sampleDate);
    }

    public void testParseDelegateClassMethod() throws Exception {
        Date april26Of1949 = new GregorianCalendar(1949, 4, 26).getTime();
        String format = new SimpleDateFormat(dateFormat).format(april26Of1949);
        TypeAdapter.registerParseDelegate(Date.class, DateFormater.class);
        this.adapter = TypeAdapter.on((Fixture)this.f, this.f.getClass().getField("sampleDate"));
        this.adapter.set(this.adapter.parse(format));
        TypeAdapterTest.assertEquals((Object)april26Of1949, (Object)this.f.sampleDate);
    }

    public void testParsedelegateClassShouldHavePublicStaticNonVoidParseMethodWithStringParam() throws Exception {
        TypeAdapter.registerParseDelegate(Class.class, PublicStaticParseMethod.class);
    }

    public void testShouldThrowNoSuchMethodExceptionIfGivenParseDelgateClassDoesNotHavePublicParseMethod() throws Exception {
        try {
            TypeAdapter.registerParseDelegate(Class.class, ProtectedParseMethod.class);
        }
        catch (RuntimeException e) {
            TypeAdapterTest.assertEquals((String)("Parse delegate class " + ProtectedParseMethod.class.getName() + " does not have a suitable static parse() method."), (String)e.getMessage());
        }
    }

    public void testShouldThrowNoSuchMethodExceptionIfGivenParseDelgateClassDoesNotHaveStaticParseMethod() throws Exception {
        try {
            TypeAdapter.registerParseDelegate(Class.class, PublicNonStaticParseMethod.class);
        }
        catch (RuntimeException e) {
            TypeAdapterTest.assertEquals((String)("Parse delegate class " + PublicNonStaticParseMethod.class.getName() + " does not have a suitable static parse() method."), (String)e.getMessage());
        }
    }

    public void testShouldThrowNoSuchMethodExceptionIfGivenParseDelgateClassHasParseMethodReturningVoid() throws Exception {
        try {
            TypeAdapter.registerParseDelegate(Class.class, PublicStaticVoidParseMethod.class);
        }
        catch (RuntimeException e) {
            TypeAdapterTest.assertEquals((String)("Parse delegate class " + PublicStaticVoidParseMethod.class.getName() + " does not have a suitable static parse() method."), (String)e.getMessage());
        }
    }

    public void testShouldThrowNoSuchMethodExceptionIfGivenParseDelgateClassDoesNotHaveParseMethodWithStringParam() throws Exception {
        try {
            TypeAdapter.registerParseDelegate(Class.class, PublicStaticParseMethodWithoutStringParam.class);
        }
        catch (RuntimeException e) {
            TypeAdapterTest.assertEquals((String)("Parse delegate class " + PublicStaticParseMethodWithoutStringParam.class.getName() + " does not have a suitable static parse() method."), (String)e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        TypeAdapter.clearDelegatesForNextTest();
    }

    public static class PublicStaticParseMethodWithoutStringParam {
        public static PublicStaticParseMethodWithoutStringParam parse() {
            return null;
        }
    }

    public static class PublicStaticParseMethod {
        public static ProtectedParseMethod parse(String a) {
            return new ProtectedParseMethod();
        }
    }

    public static class PublicStaticVoidParseMethod {
        public static void parse(String a) {
        }
    }

    public static class PublicNonStaticParseMethod {
        public ProtectedParseMethod parse(String a) {
            return null;
        }
    }

    public static class ProtectedParseMethod {
        protected static ProtectedParseMethod parse(String a) {
            return null;
        }
    }

    public static class DateFormater {
        public static Date parse(String date) throws ParseException {
            return new SimpleDateFormat(TypeAdapterTest.dateFormat).parse(date);
        }
    }

    static class TestFixture
    extends ColumnFixture {
        public byte sampleByte;
        public short sampleShort;
        public int sampleInt;
        public Integer sampleInteger;
        public float sampleFloat;
        public char ch;
        public String name;
        public int[] sampleArray;
        public Date sampleDate;

        TestFixture() {
        }

        public double pi() {
            return 3.141592653;
        }

        public Integer getNull() {
            return null;
        }
    }
}

