/*
 * Decompiled with CFR 0.152.
 */
package fitbook;

import fitbook.accounts.Invoice;
import fitbook.accounts.Order;
import fitnesse.fixtures.TableFixture;

public class TaxInvoice
extends TableFixture {
    private Invoice invoice = new Invoice();

    protected void doStaticTable(int rows) {
        this.check(3, 3, this.invoice.getCustomer());
        this.checkAddress();
        this.checkDelivery();
        this.check(0, 3, this.invoice.getAccountNumber());
        this.check(1, 3, this.invoice.getDateAsString());
        this.check(2, 3, this.invoice.getOrderNo());
        Order[] orderItems = this.invoice.getOrders();
        this.checkOrderItems(orderItems);
        this.checkSpecialDelivery(orderItems.length);
        this.checkTotal(orderItems.length);
    }

    private void checkOrderItems(Order[] orderItems) {
        int firstRow2 = 5;
        for (int row = 0; row < orderItems.length; ++row) {
            Order item = orderItems[row];
            this.check(firstRow2 + row, 0, "" + item.getQuantity());
            this.check(firstRow2 + row, 1, item.getPart());
            this.check(firstRow2 + row, 2, "" + item.getDescription());
            this.check(firstRow2 + row, 3, "" + item.getDispatched());
            this.check(firstRow2 + row, 4, item.getPrice());
            this.check(firstRow2 + row, 5, item.getTotal());
        }
    }

    private void check(int row, int column, String expected) {
        if (expected.equals(this.getText(row, column))) {
            this.right(row, column);
        } else {
            this.wrong(row, column, expected);
        }
    }

    private void check(int row, int column, double expected) {
        double actual = Double.valueOf(this.getText(row, column));
        if (expected == actual) {
            this.right(row, column);
        } else {
            this.wrong(row, column, "" + expected);
        }
    }

    private void checkTotal(int orderItems) {
        this.check(5 + orderItems, 5, this.invoice.getTotal());
    }

    private void checkSpecialDelivery(int orderItems) {
        this.check(6 + orderItems, 1, this.invoice.getSpecialDelivery());
    }

    private void checkAddress() {
        String[] address = this.invoice.getAddress();
        if (address.length == 4) {
            this.checkColumn(address, 0, 0);
        } else {
            this.wrong(0, 0, "Address too short");
        }
    }

    private void checkColumn(String[] s, int column, int startRow) {
        for (int row = startRow; row < s.length + startRow; ++row) {
            if (s[row - startRow].equals(this.getText(row, column))) {
                this.right(row, column);
                continue;
            }
            this.wrong(row, column, s[row - startRow]);
        }
    }

    private void checkDelivery() {
        String[] delivery = this.invoice.getDelivery();
        if (delivery.length == 3) {
            this.checkColumn(delivery, 1, 1);
        } else {
            this.wrong(1, 1, "Delivery too short");
        }
    }
}

