/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fitlibrary.closure.Closure;
import fitlibrary.global.PlugBoard;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class TestLookupClosure {
    private Derived subject = new Derived();
    private GenericTypedObject target = new GenericTypedObject(this.subject);

    @Test
    public void cannotFindPrivateMethod() throws Exception {
        Assert.assertNull((Object)PlugBoard.lookupClosure.findMethodClosure(this.target, "privateFunc", 1));
    }

    @Test
    public void cannotFindInheritedPrivateMethod() throws Exception {
        Assert.assertNull((Object)PlugBoard.lookupClosure.findMethodClosure(this.target, "inheritedPrivateFunc", 1));
    }

    @Test
    public void findInheritedPublicMethodInOrderOfInheritance() throws Exception {
        this.assertMethodFoundInClass("inheritedPublicFunc", 1, BaseOfBase.class);
    }

    @Test
    public void findOverriddenPublicMethodInOrderOfInheritance() throws Exception {
        this.assertMethodFoundInClass("overridenPublicFunc", 1, Derived.class);
    }

    @Test
    public void findLocalGetterInOrderOfInheritance() throws Exception {
        this.assertMethodFoundInClass("getInt", 0, Derived.class);
    }

    @Test
    public void findInheritedPrivateGetterInOrderOfInheritance() throws Exception {
        this.assertMethodFoundInClass("getPrivateInt", 0, BaseOfBase.class);
    }

    @Test
    public void findSetterInOrderOfInheritance() throws Exception {
        this.assertMethodFoundInClass("setInt", 1, Derived.class);
        this.assertMethodFoundInClass("setPrivateInt", 1, BaseOfBase.class);
    }

    @Test
    public void doesNotFindObjectEqualsButDerivedClassEquals() throws Exception {
        this.assertMethodFoundInClass("equals", 1, Base.class);
    }

    private void assertMethodFoundInClass(String string, int n, Class<?> clazz) throws Exception {
        Closure closure = PlugBoard.lookupClosure.findMethodClosure(this.target, string, n);
        Assert.assertNotNull((Object)closure);
        closure.invoke(this.getArgs(n));
        Assert.assertEquals(clazz, (Object)this.subject.classCalled);
    }

    private Object[] getArgs(int n) {
        Object[] objectArray = new Object[n];
        Arrays.fill(objectArray, (Object)1);
        return objectArray;
    }

    static class Derived
    extends Base {
        Derived() {
        }

        private void privateFunc(int n) {
            this.classCalled = Derived.class;
        }

        @Override
        public void overridenPublicFunc(int n) {
            this.classCalled = Derived.class;
        }

        @Override
        public int getInt() {
            this.classCalled = Derived.class;
            return 1;
        }

        @Override
        public void setInt(int n) {
            this.classCalled = Derived.class;
        }
    }

    static class Base
    extends BaseOfBase {
        Base() {
        }

        private void privateFunc(int n) {
            this.classCalled = Base.class;
        }

        private void inheritedPrivateFunc(int n) {
            this.classCalled = Base.class;
        }

        public void overridenPublicFunc(int n) {
            this.classCalled = Base.class;
        }

        public boolean equals(Object object) {
            this.classCalled = Base.class;
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    static class BaseOfBase {
        public Class<?> classCalled;

        BaseOfBase() {
        }

        public void inheritedPublicFunc(int n) {
            this.classCalled = BaseOfBase.class;
        }

        private int getPrivateInt() {
            this.classCalled = BaseOfBase.class;
            return 1;
        }

        private void setPrivateInt(int n) {
            this.classCalled = BaseOfBase.class;
        }

        public int getInt() {
            this.classCalled = Derived.class;
            return 1;
        }

        public void setInt(int n) {
            this.classCalled = Derived.class;
        }
    }
}

