/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.diff;

import fitlibrary.diff.Diff_match_patch;
import fitlibrary.diff.StringDifferencing;
import fitlibrary.tableOnParse.TableElementOnParse;
import java.util.LinkedList;

public class StringDifferencingStandard
implements StringDifferencing {
    @Override
    public void mustBeThreadSafe() {
    }

    @Override
    public String differences(String actual, String expected) {
        if (actual.length() < 6 || expected.length() < 6) {
            return "";
        }
        LinkedList<Diff_match_patch.Diff> diffs = new Diff_match_patch().diff_main(actual, expected, true);
        StringBuilder s = new StringBuilder("<hr>");
        int sameCount = 0;
        int sameButTwoCount = 0;
        int sameMaxLength = 0;
        for (Diff_match_patch.Diff diff : diffs) {
            String text = diff.text;
            int length = text.length();
            switch (diff.operation) {
                case DELETE: {
                    s.append("<strike>" + this.subst(text) + "</strike>");
                    break;
                }
                case EQUAL: {
                    s.append("<divv style='color:white'>" + text + "</divv>");
                    sameCount += length;
                    if (length <= 2) {
                        ++sameButTwoCount;
                    }
                    sameMaxLength = Math.max(sameMaxLength, length);
                    break;
                }
                case INSERT: {
                    s.append("<b>" + this.subst(text) + "</b>");
                }
            }
        }
        String result = s.toString();
        if (result.contains("  ") || result.contains("&nbsp")) {
            result = result.replace("  ", this.visibleSpace() + this.visibleSpace());
        } else if (sameButTwoCount * 10 > sameCount && sameMaxLength < 3) {
            return "";
        }
        return result + TableElementOnParse.label("diff");
    }

    protected String visibleSpace() {
        return "&Delta;";
    }

    protected String subst(String sOriginal) {
        String s = sOriginal;
        if (s.startsWith(" ")) {
            s = this.visibleSpace() + s.substring(1);
        }
        if (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1) + this.visibleSpace();
        }
        return s;
    }
}

