/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.flow.DoFlowOnTableDriver;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.object.DomainFixtured;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestDoFlowOnTableWithDomainFixture {
    final Mockery context = new Mockery();
    final DoFlowOnTableDriver doFlowDriver = new DoFlowOnTableDriver(this.context);

    @Test
    public void runWithCollectionSetUpTraverse() {
        final Table table = (Table)TableBuilderForTests.table().with(TableBuilderForTests.row().with(TableBuilderForTests.cell(), TableBuilderForTests.cell())).mock(this.context);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.allowing(table)).fromAt(0);
                this.will(1.returnValue((Object)table));
            }
        });
        DomainFixtured domainFixtured = (DomainFixtured)this.context.mock(DomainFixtured.class);
        this.doFlowDriver.startingOnTable(table);
        this.doFlowDriver.startingOnRow();
        this.doFlowDriver.interpretingRowReturning((Row)table.at(0), domainFixtured);
        this.doFlowDriver.pushingObjectOnScopeStack(domainFixtured);
        this.doFlowDriver.callingSetUpOn(domainFixtured, (Row)table.at(0));
        this.doFlowDriver.settingDomainFixture(domainFixtured);
        this.doFlowDriver.runTable(table);
    }

    @Test
    public void domainCheckSwitchesCorrectly() {
        final Table table = (Table)TableBuilderForTests.table().with(TableBuilderForTests.row().with(TableBuilderForTests.cell("checks"))).mock(this.context);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(table.at(0))).text(this.with(0), (VariableResolver)this.with(2.any(VariableResolver.class)));
                this.will(2.returnValue((Object)"checks"));
            }
        });
        this.doFlowDriver.startingOnTable(table);
        this.doFlowDriver.startingOnRowWithDomainCheck();
        this.doFlowDriver.settingDomainToCheck();
        this.doFlowDriver.runTable(table);
    }
}

