/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.Closure;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.FitLibraryExceptionInHtml;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.Finder;
import fitlibrary.ref.EntityReference;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class NonGenericFinder
implements Finder {
    public static final String FIND = "find";
    public static final String SHOW = "show";
    private String findExceptionMessage;
    private Closure findIntMethod;
    private Closure findStringMethod;
    private Closure showMethod;
    private EntityReference referenceParser;

    public NonGenericFinder(Typed typed, Evaluator evaluator) {
        String shortClassName = typed.simpleClassName();
        this.referenceParser = EntityReference.create(shortClassName.toLowerCase());
        Class[] intArg = new Class[]{Integer.TYPE};
        Class[] stringArg = new Class[]{String.class};
        Class[] showArg = new Class[]{typed.asClass()};
        String findName = evaluator.getRuntimeContext().extendedCamel("find " + shortClassName);
        String showMethodName = evaluator.getRuntimeContext().extendedCamel("show " + shortClassName);
        List<Class<?>> potentialClasses = PlugBoard.lookupTarget.possibleClasses(evaluator.getScope());
        this.findExceptionMessage = "Either " + shortClassName + " is<ul><li> A <b>Value Object</b>. So missing parse method: " + "public static " + shortClassName + " parse(String s) { } in class " + typed.getClassName() + "; or </li></li>An Entity. So missing finder method: " + "public " + shortClassName + " find" + shortClassName + "(String key) { }</li></ul>In:" + this.names(potentialClasses);
        this.findIntMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, findName, intArg);
        this.findStringMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, findName, stringArg);
        this.showMethod = PlugBoard.lookupTarget.findFixturingMethod(evaluator, showMethodName, showArg);
    }

    private String names(List<Class<?>> classes) {
        return MissingMethodException.htmlListOfClassNames(classes);
    }

    private Object callFindStringMethod(String text) throws Exception {
        if (this.findStringMethod != null) {
            return this.findStringMethod.invoke(new String[]{text});
        }
        if ("".equals(text)) {
            return null;
        }
        throw new FitLibraryExceptionInHtml(this.findExceptionMessage);
    }

    @Override
    public Object find(String text) throws Exception, IllegalAccessException, InvocationTargetException {
        if (this.findIntMethod != null) {
            int index = 0;
            try {
                index = this.referenceParser.getIndex(text);
            }
            catch (FitLibraryException e) {
                return this.callFindStringMethod(text);
            }
            return this.findIntMethod.invoke(new Integer[]{index});
        }
        return this.callFindStringMethod(text);
    }

    @Override
    public String show(Object result) throws Exception {
        Object[] args = new Object[]{result};
        if (this.showMethod != null) {
            return this.showMethod.invoke(args).toString();
        }
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    @Override
    public boolean hasFinderMethod() {
        return this.findIntMethod != null || this.findStringMethod != null;
    }
}

