/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runResults;

import fit.Counts;
import fitlibrary.runResults.TestResults;

public class TestResultsOnCounts
implements TestResults {
    public static final String PASS_COLOUR = "#cfffcf";
    public static final String FAIL_COLOUR = "#ffcfcf";
    public static final String IGNORE_COLOR = "#efefef";
    public static final String ERROR_COLOUR = "#ffffcf";
    protected final Counts counts;

    public TestResultsOnCounts(Counts counts) {
        this.counts = counts;
    }

    public TestResultsOnCounts() {
        this(new Counts());
    }

    @Override
    public void pass() {
        ++this.counts.right;
    }

    @Override
    public void fail() {
        ++this.counts.wrong;
    }

    @Override
    public void exception() {
        ++this.counts.exceptions;
    }

    @Override
    public void ignore() {
        ++this.counts.ignores;
    }

    @Override
    public void clear() {
        this.counts.right = 0;
        this.counts.wrong = 0;
        this.counts.ignores = 0;
        this.counts.exceptions = 0;
    }

    @Override
    public void add(TestResults otherResults) {
        this.counts.tally(otherResults.getCounts());
    }

    @Override
    public boolean passed() {
        return this.counts.right > 0 && this.counts.wrong == 0 & this.counts.exceptions == 0;
    }

    @Override
    public boolean failed() {
        return this.counts.wrong > 0;
    }

    @Override
    public boolean errors() {
        return this.counts.exceptions > 0;
    }

    @Override
    public boolean problems() {
        return this.counts.wrong + this.counts.exceptions > 0;
    }

    public String toString() {
        return this.counts.toString();
    }

    @Override
    public boolean matches(String rights, String wrongs, String ignores, String exceptions) {
        return this.cellValue(rights) == this.counts.right && this.cellValue(wrongs) == this.counts.wrong && this.cellValue(ignores) == this.counts.ignores && this.cellValue(exceptions) == this.counts.exceptions;
    }

    private int cellValue(String s) {
        return Integer.parseInt(s);
    }

    @Override
    public Counts getCounts() {
        return this.counts;
    }

    public String asHtmlTable() {
        String colour = IGNORE_COLOR;
        if (this.passed()) {
            colour = PASS_COLOUR;
        } else if (this.problems()) {
            colour = this.counts.exceptions > 0 ? ERROR_COLOUR : FAIL_COLOUR;
        }
        return "<html><table><tr><td " + TestResultsOnCounts.backgroundColour(colour) + ">" + this.counts.toString() + "</td></tr></table><html>";
    }

    public static String replaceCss(String html) {
        String result = html;
        result = result.replaceAll("class=\"pass\"", TestResultsOnCounts.backgroundColour(PASS_COLOUR));
        result = result.replaceAll("class=\"fail\"", TestResultsOnCounts.backgroundColour(FAIL_COLOUR));
        result = result.replaceAll("class=\"ignore\"", TestResultsOnCounts.backgroundColour(IGNORE_COLOR));
        result = result.replaceAll("class=\"error\"", TestResultsOnCounts.backgroundColour(ERROR_COLOUR));
        return result;
    }

    private static String backgroundColour(String colour) {
        return "bgcolor=\"" + colour + "\"";
    }

    @Override
    public void addRights(int extraRight) {
        this.counts.right += extraRight;
    }
}

