/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec.filter;

import fitlibrary.spec.PipeLine;
import fitlibrary.spec.filter.FoldFilter;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestFoldFilter {
    final Mockery context = new Mockery();
    final PipeLine pipeline = (PipeLine)this.context.mock(PipeLine.class);
    final FoldFilter filter = new FoldFilter(this.pipeline);

    @Test
    public void noAffectWhenBothEmpty() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFoldFilter.this.pipeline)).match("", "");
                this.will(1.returnValue((Object)true));
            }
        });
        this.filter.match("", "");
    }

    @Test
    public void noAffectWhenNoFold() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFoldFilter.this.pipeline)).match("ab", "ab");
                this.will(2.returnValue((Object)true));
            }
        });
        this.filter.match("ab", "ab");
    }

    @Test
    public void whenFoldInActual() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFoldFilter.this.pipeline)).match("abcd", "abcd");
                this.will(3.returnValue((Object)true));
            }
        });
        this.filter.match("ab<div class=\"included\">ABC</div></div>cd", "abcd");
    }

    @Test
    public void whenFoldInExpected() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFoldFilter.this.pipeline)).match("abcd", "abcd");
                this.will(4.returnValue((Object)true));
            }
        });
        this.filter.match("abcd", "ab<div class=\"included\">ABC</div></div>cd");
    }

    @Test
    public void whenFoldInBoth() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestFoldFilter.this.pipeline)).match("abcd", "abcd");
                this.will(5.returnValue((Object)true));
            }
        });
        String string = "ab<div class=\"included\">ABC</div></div>cd";
        this.filter.match(string, string);
    }
}

