/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.special;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.closure.MethodClosure;
import fitlibrary.global.PlugBoard;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.special.DoAction;
import fitlibrary.special.DoActionInContext;
import fitlibrary.special.PositionedTarget;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.Method;

public class PositionedTargetWasFound
implements PositionedTarget {
    private final int innerFrom;
    private final int innerUpTo;
    private final boolean sequencing;
    private String specialName;
    private ICalledMethodTarget innerTarget;
    private final ICalledMethodTarget specialTarget;
    private String innerName = "";
    private String innerTargetMissingMessage = "";

    public PositionedTargetWasFound(Evaluator evaluator, String[] cells, TypedObject typedObject, Method method, int innerFrom, int innerUpTo, boolean sequencing, LookupMethodTarget lookupTarget) {
        this.innerFrom = innerFrom;
        this.innerUpTo = innerUpTo;
        this.sequencing = sequencing;
        this.specialName = method.getName();
        this.specialTarget = new CalledMethodTarget(new MethodClosure(typedObject, method), evaluator);
        int argCount = 0;
        argCount = this.determineInnerSignature(cells, evaluator.getRuntimeContext());
        try {
            this.innerTarget = lookupTarget.findTheMethodMapped(this.innerName, argCount, evaluator);
        }
        catch (Exception e) {
            this.innerTargetMissingMessage = e.getMessage();
        }
    }

    private int determineInnerSignature(String[] cells, RuntimeContextInternal runtime) {
        if (this.sequencing) {
            this.innerName = cells[this.innerFrom];
            return this.innerUpTo - this.innerFrom - 1;
        }
        for (int i = this.innerFrom; i < this.innerUpTo; i += 2) {
            this.innerName = this.innerName + " " + cells[i];
        }
        this.innerName = runtime.extendedCamel(this.innerName);
        return (this.innerUpTo - this.innerFrom) / 2;
    }

    @Override
    public boolean isFound() {
        return this.specialTarget != null && this.innerTarget != null;
    }

    @Override
    public String ambiguityErrorMessage() {
        return "Special " + this.specialName + "(" + this.args(this.specialTarget) + ") + " + this.innerName + "(" + this.args(this.innerTarget) + ") (in " + this.specialTarget.getOwningClass().getName() + " + " + this.innerTarget.getOwningClass().getName() + ")";
    }

    @Override
    public boolean partiallyValid() {
        return this.specialTarget != null;
    }

    @Override
    public String getPartialErrorMessage() {
        return this.innerTargetMissingMessage;
    }

    @Override
    public TypedObject run(Row row, TestResults testResults, RuntimeContextInternal runtime) {
        try {
            Object[] args = this.createArguments(new DoActionInContext(this.innerTarget, row, this.innerFrom, this.innerUpTo, this.sequencing, runtime), testResults, row);
            Object result = this.specialTarget.invoke(args);
            if (result instanceof Boolean) {
                if (((Boolean)result).booleanValue()) {
                    ((Cell)row.at(0)).pass(testResults);
                } else {
                    ((Cell)row.at(0)).fail(testResults);
                }
            }
            return new GenericTypedObject(result);
        }
        catch (Exception e) {
            if (PlugBoard.exceptionHandling.unwrappedIsShow(e)) {
                ((Cell)row.at(this.operatorCell())).error(testResults);
            }
            row.error(testResults, e);
            return null;
        }
    }

    private int operatorCell() {
        if (this.innerFrom == 0) {
            return this.innerUpTo;
        }
        return 0;
    }

    private String args(ICalledMethodTarget target) {
        Class<?>[] parameterTypes = target.getParameterTypes();
        if (parameterTypes.length == 0) {
            return "";
        }
        String s = "";
        for (Class<?> t : parameterTypes) {
            s = s + "," + t.getSimpleName();
        }
        return s.substring(1);
    }

    private Object[] createArguments(DoAction action, TestResults testResults, Row row) throws Exception {
        if (this.innerFrom == 0) {
            return this.createPostArguments(action, testResults, row);
        }
        return this.createPreArguments(action, testResults, row);
    }

    private Object[] createPreArguments(DoAction action, TestResults testResults, Row row) throws Exception {
        Parser[] parameterParsers = this.specialTarget.getParameterParsers();
        Class<?>[] parameterTypes = this.specialTarget.getParameterTypes();
        Object[] args = new Object[parameterParsers.length];
        for (int i = 0; i < parameterParsers.length - 1; ++i) {
            Parser parser = parameterTypes[i] == Object.class ? this.innerTarget.getResultParser() : parameterParsers[i];
            args[i] = parser.parseTyped((Cell)row.at(i * 2 + 1), testResults).getSubject();
        }
        args[parameterParsers.length - 1] = action;
        return args;
    }

    private Object[] createPostArguments(DoAction action, TestResults testResults, Row row) throws Exception {
        Parser[] parameterParsers = this.specialTarget.getParameterParsers();
        Class<?>[] parameterTypes = this.specialTarget.getParameterTypes();
        Object[] args = new Object[parameterParsers.length];
        args[0] = action;
        for (int i = 1; i < parameterParsers.length; ++i) {
            Parser parser = parameterTypes[i] == Object.class ? this.innerTarget.getResultParser() : parameterParsers[i];
            args[i] = parser.parseTyped((Cell)row.at(this.innerUpTo + i * 2 - 1), testResults).getSubject();
        }
        return args;
    }
}

