/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.special;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.LookupClosure;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.flow.IScope;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.special.DoAction;
import fitlibrary.special.PositionedTargetWasFound;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.utility.Pair;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestPositionedTargetWasFound {
    final Mockery context = new Mockery();
    final Subject subject = (Subject)this.context.mock(Subject.class);
    final Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class);
    final LookupClosure lookupClosure = (LookupClosure)this.context.mock(LookupClosure.class);
    final GenericTypedObject.MethodTargetFactory methodTargetFactory = (GenericTypedObject.MethodTargetFactory)this.context.mock(GenericTypedObject.MethodTargetFactory.class);
    final LookupMethodTarget lookupMethodTarget = (LookupMethodTarget)this.context.mock(LookupMethodTarget.class);
    final ICalledMethodTarget innerMethodTarget = (ICalledMethodTarget)this.context.mock(ICalledMethodTarget.class, "inner");
    final IScope scope = (IScope)this.context.mock(IScope.class);
    final TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    final RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);
    final Parser intParser = (Parser)this.context.mock(Parser.class);
    final GenericTypedObject typedObject = new GenericTypedObject(this.subject, this.lookupClosure, this.methodTargetFactory);

    @Before
    public void allowingExpectations() {
        final ArrayList<GenericTypedObject> arrayList = new ArrayList<GenericTypedObject>();
        arrayList.add(this.typedObject);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.allowing(TestPositionedTargetWasFound.this.evaluator)).getScope();
                this.will(1.returnValue((Object)TestPositionedTargetWasFound.this.scope));
                ((IScope)this.allowing(TestPositionedTargetWasFound.this.scope)).possibleClasses();
                this.will(1.returnValue(new ArrayList()));
                ((IScope)this.allowing(TestPositionedTargetWasFound.this.scope)).objectsForLookup();
                this.will(1.returnValue((Object)arrayList));
                ((ICalledMethodTarget)this.allowing(TestPositionedTargetWasFound.this.innerMethodTarget)).getParameterTypes();
                this.will(1.returnValue((Object)new Class[0]));
                ((ICalledMethodTarget)this.allowing(TestPositionedTargetWasFound.this.innerMethodTarget)).getOwningClass();
                this.will(1.returnValue(Subject.class));
                ((Evaluator)this.allowing(TestPositionedTargetWasFound.this.evaluator)).getRuntimeContext();
                this.will(1.returnValue((Object)TestPositionedTargetWasFound.this.runtime));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("find String");
                this.will(1.returnValue((Object)"findString"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("show String");
                this.will(1.returnValue((Object)"showString"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("find DoAction");
                this.will(1.returnValue((Object)"findDoAction"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("show DoAction");
                this.will(1.returnValue((Object)"showDoAction"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("find boolean");
                this.will(1.returnValue((Object)"findBoolean"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("show boolean");
                this.will(1.returnValue((Object)"showBoolean"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("find void");
                this.will(1.returnValue((Object)"findVoid"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("show void");
                this.will(1.returnValue((Object)"showVoid"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("find Object");
                this.will(1.returnValue((Object)"findObject"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("show Object");
                this.will(1.returnValue((Object)"showObject"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel(" m");
                this.will(1.returnValue((Object)"m"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel("m");
                this.will(1.returnValue((Object)"m"));
                ((RuntimeContextInternal)this.allowing(TestPositionedTargetWasFound.this.runtime)).extendedCamel(" n");
                this.will(1.returnValue((Object)"n"));
            }
        });
    }

    @Test
    public void binaryPrefixInnerTargetNotFound() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupMethodTarget)this.oneOf(TestPositionedTargetWasFound.this.lookupMethodTarget)).findTheMethodMapped("m", 1, TestPositionedTargetWasFound.this.evaluator);
                this.will(2.returnValue(null));
            }
        });
        String[] stringArray = new String[]{"binary", "1", "preSpecial", "2", "m", "a"};
        Method method = this.getMethod("binaryPreSpecial", String.class, String.class, DoAction.class);
        PositionedTargetWasFound positionedTargetWasFound = new PositionedTargetWasFound(this.evaluator, stringArray, this.typedObject, method, 4, 6, false, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)positionedTargetWasFound.isFound(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void binaryPrefixInnerRunsReturningTrue() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupMethodTarget)this.oneOf(TestPositionedTargetWasFound.this.lookupMethodTarget)).findTheMethodMapped("m", 0, TestPositionedTargetWasFound.this.evaluator);
                this.will(3.returnValue((Object)TestPositionedTargetWasFound.this.innerMethodTarget));
                ((Evaluator)this.allowing(TestPositionedTargetWasFound.this.evaluator)).resolve("1");
                this.will(TestPositionedTargetWasFound.this.resolveTo("1"));
                ((Evaluator)this.allowing(TestPositionedTargetWasFound.this.evaluator)).resolve("2");
                this.will(TestPositionedTargetWasFound.this.resolveTo("2"));
                ((Subject)this.oneOf(TestPositionedTargetWasFound.this.subject)).binaryPreSpecial((String)this.with(CoreMatchers.is((Object)"1")), (String)this.with(CoreMatchers.is((Object)"2")), (DoAction)this.with(3.any(DoAction.class)));
                this.will(3.returnValue((Object)true));
                ((TestResults)this.oneOf(TestPositionedTargetWasFound.this.testResults)).pass();
            }
        });
        String[] stringArray = new String[]{"binary", "1", "preSpecial", "2", "m"};
        Method method = this.getMethod("binaryPreSpecial", String.class, String.class, DoAction.class);
        PositionedTargetWasFound positionedTargetWasFound = new PositionedTargetWasFound(this.evaluator, stringArray, this.typedObject, method, 4, 5, false, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)positionedTargetWasFound.isFound(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)positionedTargetWasFound.ambiguityErrorMessage(), (Matcher)CoreMatchers.startsWith((String)"Special binaryPreSpecial(String,String,DoAction) + m()"));
        Row row = TableFactory.row(stringArray);
        positionedTargetWasFound.run(row, this.testResults, this.runtime);
    }

    @Test
    public void binaryPostfixInnerTargetNotFound() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupMethodTarget)this.oneOf(TestPositionedTargetWasFound.this.lookupMethodTarget)).findTheMethodMapped("m", 1, TestPositionedTargetWasFound.this.evaluator);
                this.will(4.returnValue(null));
            }
        });
        String[] stringArray = new String[]{"m", "a", "binary", "1", "postSpecial", "2"};
        Method method = this.getMethod("binaryPostSpecial", DoAction.class, String.class, String.class);
        PositionedTargetWasFound positionedTargetWasFound = new PositionedTargetWasFound(this.evaluator, stringArray, this.typedObject, method, 0, 2, false, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)positionedTargetWasFound.isFound(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void binaryPostfixInnerRunsReturningFalse() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupMethodTarget)this.oneOf(TestPositionedTargetWasFound.this.lookupMethodTarget)).findTheMethodMapped("m", 0, TestPositionedTargetWasFound.this.evaluator);
                this.will(5.returnValue((Object)TestPositionedTargetWasFound.this.innerMethodTarget));
                ((Evaluator)this.allowing(TestPositionedTargetWasFound.this.evaluator)).resolve("1");
                this.will(TestPositionedTargetWasFound.this.resolveTo("1"));
                ((Evaluator)this.allowing(TestPositionedTargetWasFound.this.evaluator)).resolve("2");
                this.will(TestPositionedTargetWasFound.this.resolveTo("2"));
                ((Subject)this.oneOf(TestPositionedTargetWasFound.this.subject)).binaryPostSpecial((DoAction)this.with(5.any(DoAction.class)), (String)this.with(CoreMatchers.is((Object)"1")), (String)this.with(CoreMatchers.is((Object)"2")));
                this.will(5.returnValue((Object)false));
                ((TestResults)this.oneOf(TestPositionedTargetWasFound.this.testResults)).fail();
            }
        });
        String[] stringArray = new String[]{"m", "binary", "1", "postSpecial", "2"};
        Method method = this.getMethod("binaryPostSpecial", DoAction.class, String.class, String.class);
        PositionedTargetWasFound positionedTargetWasFound = new PositionedTargetWasFound(this.evaluator, stringArray, this.typedObject, method, 0, 1, false, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)positionedTargetWasFound.isFound(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)positionedTargetWasFound.ambiguityErrorMessage(), (Matcher)CoreMatchers.startsWith((String)"Special binaryPostSpecial(DoAction,String,String) + m()"));
        Row row = TableFactory.row(stringArray);
        positionedTargetWasFound.run(row, this.testResults, this.runtime);
    }

    @Test
    public void nullaryInnerRunsReturningNothing() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupMethodTarget)this.oneOf(TestPositionedTargetWasFound.this.lookupMethodTarget)).findTheMethodMapped("n", 1, TestPositionedTargetWasFound.this.evaluator);
                this.will(6.returnValue((Object)TestPositionedTargetWasFound.this.innerMethodTarget));
                ((Subject)this.oneOf(TestPositionedTargetWasFound.this.subject)).nullarySpecial((DoAction)this.with(6.any(DoAction.class)));
            }
        });
        String[] stringArray = new String[]{"nullarySpecial", "n", "z"};
        Method method = this.getMethod("nullarySpecial", DoAction.class);
        PositionedTargetWasFound positionedTargetWasFound = new PositionedTargetWasFound(this.evaluator, stringArray, this.typedObject, method, 1, 3, false, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)positionedTargetWasFound.isFound(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)positionedTargetWasFound.ambiguityErrorMessage(), (Matcher)CoreMatchers.startsWith((String)"Special nullarySpecial(DoAction) + n()"));
        Row row = TableFactory.row(stringArray);
        positionedTargetWasFound.run(row, this.testResults, this.runtime);
    }

    @Test
    public void unaryPostfixTakesObject() throws Exception {
        String[] stringArray = new String[]{"m", "unaryPostSpecial", "2"};
        final Row row = TableFactory.row(stringArray);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((LookupMethodTarget)this.oneOf(TestPositionedTargetWasFound.this.lookupMethodTarget)).findTheMethodMapped("m", 0, TestPositionedTargetWasFound.this.evaluator);
                this.will(7.returnValue((Object)TestPositionedTargetWasFound.this.innerMethodTarget));
                ((ICalledMethodTarget)this.oneOf(TestPositionedTargetWasFound.this.innerMethodTarget)).getResultParser();
                this.will(7.returnValue((Object)TestPositionedTargetWasFound.this.intParser));
                ((Parser)this.oneOf(TestPositionedTargetWasFound.this.intParser)).parseTyped((Cell)row.at(2), TestPositionedTargetWasFound.this.testResults);
                this.will(7.returnValue((Object)new GenericTypedObject(2)));
                ((Subject)this.oneOf(TestPositionedTargetWasFound.this.subject)).unaryPostSpecial((DoAction)this.with(7.any(DoAction.class)), this.with(CoreMatchers.is((Object)2)));
            }
        });
        Method method = this.getMethod("unaryPostSpecial", DoAction.class, Object.class);
        PositionedTargetWasFound positionedTargetWasFound = new PositionedTargetWasFound(this.evaluator, stringArray, this.typedObject, method, 0, 1, false, this.lookupMethodTarget);
        MatcherAssert.assertThat((Object)positionedTargetWasFound.isFound(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)positionedTargetWasFound.ambiguityErrorMessage(), (Matcher)CoreMatchers.startsWith((String)"Special unaryPostSpecial(DoAction,Object) + m()"));
        positionedTargetWasFound.run(row, this.testResults, this.runtime);
    }

    private Method getMethod(String string, Class<?> ... classArray) throws NoSuchMethodException {
        Method method = this.subject.getClass().getMethod(string, classArray);
        return method;
    }

    protected Action resolveTo(String string) {
        return Expectations.returnValue(new Pair<String, Tables>(string, TableFactory.tables()));
    }

    static interface Subject {
        public int m();

        public void n(String var1);

        public void nullarySpecial(DoAction var1);

        public void unaryPostSpecial(DoAction var1, Object var2);

        public boolean binaryPreSpecial(String var1, String var2, DoAction var3);

        public boolean binaryPostSpecial(DoAction var1, String var2, String var3);
    }
}

