/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fitlibrary.dynamicVariable.DynamicVariablesRecording;
import fitlibrary.flow.DoFlow;
import fitlibrary.flow.DoFlowWithExtraTableAddedWhenNeeded;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.flow.ScopeStack;
import fitlibrary.flow.SetUpTearDownCache;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.runResults.TableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextContainer;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.suite.Reportage;
import fitlibrary.suite.StorytestRunner;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.tableOnParse.TableElementOnParse;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.io.IOException;

public class BatchFitLibrary
implements StorytestRunner {
    private static final boolean SHOW_LOGS = false;
    public static final boolean SHOW_EXCEPTION_STACKS = false;
    protected TableListener tableListener = new TableListener(TestResultsFactory.testResults());
    protected DoFlow doFlow = BatchFitLibrary.wiredUpDoFlow();

    public BatchFitLibrary() {
    }

    public BatchFitLibrary(TableListener tableListener) {
        this.tableListener = tableListener;
    }

    @Override
    public TestResults doStorytest(Tables theTables) {
        ParseDelegation.clearDelegatesForNextStorytest();
        return this.doTables(theTables);
    }

    public TestResults doStorytest(Tables theTables, Object externalObject) {
        ParseDelegation.clearDelegatesForNextStorytest();
        this.doFlow.getRuntimeContext().getScope().addGlobal(new GenericTypedObject(externalObject));
        return this.doTables(theTables);
    }

    private static DoFlow wiredUpDoFlow() {
        DoTraverse flowEvaluator = new DoTraverse();
        GlobalActionScope global = new GlobalActionScope();
        GenericTypedObject globalTO = new GenericTypedObject(global);
        ScopeStack scopeStack = new ScopeStack(flowEvaluator, globalTO);
        RuntimeContextContainer runtime = new RuntimeContextContainer(scopeStack, global);
        BatchFitLibrary.attemptToAddGlobalForFitLibraryWeb(scopeStack, runtime);
        runtime.setDynamicVariable("fitNesse.url", FitServerBridge.FITNESSE_URL);
        global.setRuntimeContext(runtime);
        flowEvaluator.setRuntimeContext(runtime);
        DoFlowWithExtraTableAddedWhenNeeded doFlow2 = new DoFlowWithExtraTableAddedWhenNeeded(flowEvaluator, scopeStack, runtime, new SetUpTearDownCache());
        runtime.setTableEvaluator(doFlow2);
        return doFlow2;
    }

    private static void attemptToAddGlobalForFitLibraryWeb(ScopeStack scopeStack, RuntimeContextInternal runtime) {
        try {
            GenericTypedObject typedObject = new GenericTypedObject(Class.forName("fitlibrary.flow.GlobalActionScopeForWeb").newInstance());
            typedObject.injectRuntime(runtime);
            scopeStack.addGlobal(typedObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentPageName(String name) {
        this.doFlow.getRuntimeContext().setCurrentPageName(name);
    }

    public TestResults doTables(Tables theTables) {
        this.tableListener.clearTestResults();
        this.doFlow.runStorytest(theTables, this.tableListener);
        DynamicVariablesRecording recorder = this.doFlow.getRuntimeContext().getDynamicVariableRecorder();
        if (recorder.isRecording()) {
            try {
                recorder.write();
            }
            catch (IOException e) {
                Table errorTable = TableFactory.table(TableFactory.row("note", TableElementOnParse.label("Problem on writing property file:") + "<hr/>" + e.getMessage()));
                ((Cell)((Row)errorTable.at(0)).at(1)).error(this.tableListener.getTestResults());
                theTables.add(errorTable);
            }
        }
        return this.tableListener.getTestResults();
    }

    public void doTables(Tables theTables, TableListener listener) {
        this.tableListener = listener;
        this.doStorytest(theTables);
    }

    public void exit() {
        this.doFlow.exit();
    }

    public static class DefaultReportage
    implements Reportage {
        @Override
        public void showAllReports() {
        }
    }
}

