/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tableOnParse;

import fit.Parse;
import fitlibrary.exception.table.MissingRowException;
import fitlibrary.runResults.ITableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.tableOnParse.RowOnParse;
import fitlibrary.tableOnParse.TableElementOnParse;
import fitlibrary.tableOnParse.TablesOnParse;

public class TableOnParse
extends TableElementOnParse<Row>
implements Table {
    private int firstErrorRow = 0;

    public TableOnParse(Parse parse) {
        super(parse);
    }

    public TableOnParse() {
        super(new Parse("table", "", null, null));
        this.parse().addToTag(" border=\"1\" cellspacing=\"0\"");
    }

    public TableOnParse(Row ... rows) {
        this();
        for (Row row : rows) {
            this.add(row);
        }
    }

    @Override
    public int size() {
        if (this.parse == null || this.parse.parts == null) {
            return 0;
        }
        return this.parse.parts.size();
    }

    @Override
    public Row at(int i) {
        if (!this.atExists(i)) {
            throw new MissingRowException("");
        }
        return new RowOnParse(this.parse.parts.at(i));
    }

    @Override
    public void pass(TestResults testResults) {
        this.at(this.firstErrorRow).pass(testResults);
    }

    @Override
    public void ignore(TestResults testResults) {
        this.at(this.firstErrorRow).ignore(testResults);
    }

    @Override
    public void error(TestResults testResults, Throwable e) {
        this.at(this.firstErrorRow).error(testResults, e);
    }

    @Override
    public void error(ITableListener tableListener, Throwable e) {
        this.error(tableListener.getTestResults(), e);
    }

    @Override
    public TableOnParse add(Row row) {
        if (this.parse.parts == null) {
            this.parse.parts = row.parse();
        } else {
            this.parse.parts.last().more = row.parse();
        }
        return this;
    }

    @Override
    public void add(int i, Row row) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void removeElementAt(int i) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Row newRow() {
        Row row = TableFactory.row();
        this.add(row);
        return row;
    }

    @Override
    public int phaseBoundaryCount() {
        int count = this.parse.leader.split("<hr>").length - 1;
        if (count == 0) {
            count = this.parse.leader.split("<hr/>").length - 1;
        }
        return count;
    }

    @Override
    public void addFoldingText(String fold) {
        if (this.parse.more != null) {
            new TableOnParse(this.parse.more).addToStartOfLeader(fold);
        } else {
            this.addToTrailer(fold);
        }
    }

    public TablesOnParse getTables() {
        return new TablesOnParse(this.parse);
    }

    @Override
    public void evenUpRows() {
        int maxRowLength = this.getMaxRowColumnSpan();
        for (Row row : this) {
            row.setColumnSpan(maxRowLength);
        }
    }

    private int getMaxRowColumnSpan() {
        int maxLength = 0;
        for (Row row : this) {
            maxLength = Math.max(maxLength, row.getColumnSpan());
        }
        return maxLength;
    }

    @Override
    public boolean isPlainTextTable() {
        return this.parse().tag.contains("plain_text_table");
    }

    @Override
    public void replaceAt(int t, Row row) {
        row.parse().more = this.parse().parts.at((int)t).more;
        if (t == 0) {
            this.parse().parts = row.parse();
        } else {
            this.parse().parts.at((int)(t - 1)).more = row.parse();
        }
    }

    @Override
    public Table deepCopy() {
        Table copy = TableFactory.table();
        for (Row row : this) {
            copy.add(row.deepCopy());
        }
        copy.setLeader(this.getLeader());
        copy.setTrailer(this.getTrailer());
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.parse.more == null;
    }

    @Override
    public String getType() {
        return "Table";
    }

    @Override
    public boolean hasRowsAfter(Row currentRow) {
        for (int i = 0; i < this.size() - 1; ++i) {
            if (this.at(i).parse() != currentRow.parse()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Table fromAt(int rowNo) {
        if (rowNo == 0) {
            return this;
        }
        return TableFactory.table(this.at(rowNo));
    }

    @Override
    public Table fromTo(int from, int upto) {
        Table result = TableFactory.table();
        for (int i = from; i < upto; ++i) {
            result.add(this.at(i).deepCopy());
        }
        return result;
    }

    @Override
    public Table asTableOnParse() {
        return this;
    }
}

