/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tableOnParse;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.runResults.TableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.tableOnParse.CellOnParse;
import fitlibrary.tableOnParse.RowOnParse;
import fitlibrary.tableOnParse.TableOnParse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestTableOnParse {
    Mockery context = new Mockery();
    TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    VariableResolver resolver = (VariableResolver)this.context.mock(VariableResolver.class);
    Row row0 = new RowOnParse();
    Row row1 = new RowOnParse();
    Row row2 = new RowOnParse();
    Table table01;

    @Before
    public void useListsFactory() {
        TableFactory.useOnLists(false);
        this.row0.add(new CellOnParse("0"));
        this.row1.add(new CellOnParse("1"));
        this.row2.add(new CellOnParse("2"));
        this.table01 = TestTableOnParse.table(this.row0, this.row1);
    }

    @After
    public void stopUsingListsFactory() {
        TableFactory.pop();
    }

    @Test
    public void pass() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestTableOnParse.this.testResults)).pass();
            }
        });
        this.table01.pass(this.testResults);
        MatcherAssert.assertThat((Object)((Row)this.table01.at(0)).didPass(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void ignore() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestTableOnParse.this.testResults)).ignore();
            }
        });
        this.table01.ignore(this.testResults);
    }

    @Test
    public void error() {
        RuntimeException runtimeException = new RuntimeException();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestTableOnParse.this.testResults)).exception();
            }
        });
        this.table01.error(this.testResults, (Throwable)runtimeException);
        MatcherAssert.assertThat((Object)((Cell)((Row)this.table01.at(0)).at(0)).hadError(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void errorWithTableListener() {
        RuntimeException runtimeException = new RuntimeException();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestTableOnParse.this.testResults)).exception();
            }
        });
        this.table01.error(new TableListener(this.testResults), (Throwable)runtimeException);
    }

    @Test
    public void newRow() {
        this.table01.newRow();
        MatcherAssert.assertThat((Object)this.table01.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void phaseBoundaryCount() {
        this.table01.setLeader("12<hr/>34<hr/>456<hr/>");
        MatcherAssert.assertThat((Object)this.table01.phaseBoundaryCount(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void addFoldingText() {
        this.table01.addFoldingText("12");
        MatcherAssert.assertThat((Object)this.table01.getTrailer(), (Matcher)CoreMatchers.is((Object)"12"));
    }

    @Test
    public void replaceAt() {
        this.table01.replaceAt(0, this.row2);
        MatcherAssert.assertThat((Object)this.table01.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(this.table01.at(0), (Matcher)CoreMatchers.is((Object)this.row2));
        MatcherAssert.assertThat(this.table01.at(1), (Matcher)CoreMatchers.is((Object)this.row1));
    }

    @Test
    public void replaceAtAfter() {
        this.table01.replaceAt(2, this.row2);
        MatcherAssert.assertThat((Object)this.table01.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(this.table01.at(0), (Matcher)CoreMatchers.is((Object)this.row0));
        MatcherAssert.assertThat(this.table01.at(1), (Matcher)CoreMatchers.is((Object)this.row1));
        MatcherAssert.assertThat(this.table01.at(2), (Matcher)CoreMatchers.is((Object)this.row2));
    }

    @Test
    public void fromAt0() {
        Table table = (Table)this.table01.fromAt(0);
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)this.row0));
        MatcherAssert.assertThat(table.at(1), (Matcher)CoreMatchers.is((Object)this.row1));
    }

    @Test
    public void fromAt1() {
        Table table = (Table)this.table01.fromAt(1);
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(table.at(0), (Matcher)CoreMatchers.is((Object)this.row1));
    }

    @Test
    public void hasRowsAfter() {
        MatcherAssert.assertThat((Object)this.table01.hasRowsAfter(this.row0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.table01.hasRowsAfter(this.row1), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.table01.hasRowsAfter(this.row2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void deepCopy() {
        this.table01.setLeader("LL");
        this.table01.setTrailer("TT");
        Table table = (Table)this.table01.deepCopy();
        MatcherAssert.assertThat((Object)table.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Cell)((Row)table.at(0)).at(0)).text(), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((Cell)((Row)table.at(1)).at(0)).text(), (Matcher)CoreMatchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)table.getLeader(), (Matcher)CoreMatchers.is((Object)"LL"));
        MatcherAssert.assertThat((Object)table.getTrailer(), (Matcher)CoreMatchers.is((Object)"TT"));
    }

    @Test
    public void toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        this.table01.setLeader("LL");
        this.table01.setTrailer("TT");
        this.table01.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)"LL<table border=\"1\" cellspacing=\"0\">\n<tr>\n<td>0</td></tr>\n<tr>\n<td>1</td></tr></table>TT"));
    }

    protected static Table table(Row ... rowArray) {
        TableOnParse tableOnParse = new TableOnParse();
        for (Row row : rowArray) {
            tableOnParse.add(row);
        }
        return tableOnParse;
    }
}

