/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.function;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.method.VoidMethodException;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.option.None;
import fitlibrary.utility.option.Option;
import fitlibrary.utility.option.Some;
import java.util.ArrayList;
import java.util.List;

public class RuleTable
extends Traverse {
    private List<ColumnTarget> columnTargets = new ArrayList<ColumnTarget>();
    private boolean hasErrors = false;
    private Option<ICalledMethodTarget> executeMethod = None.none();
    private Option<ICalledMethodTarget> resetMethod = None.none();

    public RuleTable(Object sut) {
        super(sut);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            this.basicCheck(table, testResults);
            this.header(table, testResults);
            this.optionalfunctions();
            if (!this.hasErrors) {
                this.body(table, testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            ((Row)table.at(1)).error(testResults, e);
        }
        return null;
    }

    private void header(Table table, TestResults testResults) {
        Row headerRow = (Row)table.at(1);
        for (Cell cell : headerRow) {
            try {
                String name = cell.text(this);
                boolean input = true;
                if (name.endsWith("?")) {
                    input = false;
                    name = name.substring(0, name.length() - 1);
                }
                String fn = this.extendedCamel(name);
                if (input) {
                    this.columnTargets.add(new InputColumnTarget(PlugBoard.lookupTarget.findSetterOnSut(fn, this)));
                    continue;
                }
                ICalledMethodTarget target = PlugBoard.lookupTarget.findGetterOnSut(fn, this, "Rule");
                if (target.returnsVoid()) {
                    throw new VoidMethodException(fn, "RuleTable");
                }
                this.columnTargets.add(new OutputColumnTarget(target));
            }
            catch (Exception e) {
                cell.error(testResults, e);
                this.hasErrors = true;
            }
        }
    }

    private void body(Table table, TestResults testResults) {
        for (int r = 2; r < table.size(); ++r) {
            Row row = (Row)table.at(r);
            try {
                if (this.resetMethod.isSome()) {
                    this.resetMethod.get().invoke();
                }
                this.row(testResults, row);
                continue;
            }
            catch (Exception e) {
                row.error(testResults, e);
            }
        }
    }

    private void row(TestResults testResults, Row row) throws Exception {
        boolean haveCalledExecuteForThisRow = this.executeMethod.isNone();
        for (int i = 0; i < row.size(); ++i) {
            Cell cell = (Cell)row.at(i);
            try {
                ColumnTarget columnTarget = this.columnTargets.get(i);
                if (!haveCalledExecuteForThisRow && columnTarget.isOutput()) {
                    this.executeMethod.get().invoke();
                    haveCalledExecuteForThisRow = true;
                }
                columnTarget.act(cell, testResults);
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
                return;
            }
        }
    }

    private void basicCheck(Table table, TestResults testResults) {
        int width = ((Row)table.at(1)).size();
        for (int r = 2; r < table.size(); ++r) {
            Row row = (Row)table.at(r);
            if (width == row.size()) continue;
            ((Cell)row.at(0)).error(testResults, "Irregular shaped: This row differs in width from the header");
            throw new IgnoredException();
        }
    }

    private void optionalfunctions() {
        try {
            this.resetMethod = new Some<ICalledMethodTarget>(PlugBoard.lookupTarget.findTheMethodMapped("reset", 0, this));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.executeMethod = new Some<ICalledMethodTarget>(PlugBoard.lookupTarget.findTheMethodMapped("execute", 0, this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class OutputColumnTarget
    extends ColumnTarget {
        public OutputColumnTarget(ICalledMethodTarget target) {
            super(target);
        }

        @Override
        public void act(Cell cell, TestResults testResults) throws Exception {
            this.target.invokeAndCheckCell(cell, true, testResults);
        }

        @Override
        public boolean isOutput() {
            return true;
        }
    }

    static class InputColumnTarget
    extends ColumnTarget {
        public InputColumnTarget(ICalledMethodTarget target) {
            super(target);
        }

        @Override
        public void act(Cell cell, TestResults testResults) throws Exception {
            this.target.invoke(cell, testResults);
        }

        @Override
        public boolean isOutput() {
            return false;
        }
    }

    static abstract class ColumnTarget {
        protected ICalledMethodTarget target;

        public ColumnTarget(ICalledMethodTarget target) {
            this.target = target;
        }

        public abstract boolean isOutput();

        public abstract void act(Cell var1, TestResults var2) throws Exception;
    }
}

