/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fitlibrary.DefineAction;
import fitlibrary.annotation.ActionType;
import fitlibrary.annotation.AnAction;
import fitlibrary.annotation.NullaryAction;
import fitlibrary.annotation.ShowSelectedActions;
import fitlibrary.annotation.SimpleAction;
import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.domainAdapter.FileHandler;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.flow.DoAutoWrapper;
import fitlibrary.flow.IDoAutoWrapper;
import fitlibrary.global.PlugBoard;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.parser.graphic.GraphicParser;
import fitlibrary.parser.graphic.ObjectDotGraphic;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.FitHandler;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.function.CalculateTraverse;
import fitlibrary.traverse.function.ConstraintTraverse;
import fitlibrary.traverse.workflow.DispatchRowInFlow;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibrary.traverse.workflow.RandomSelectTraverse;
import fitlibrary.traverse.workflow.SetVariableTraverse;
import fitlibrary.traverse.workflow.caller.DefinedActionCaller;
import fitlibrary.traverse.workflow.caller.TwoStageSpecial;
import fitlibrary.traverse.workflow.special.PrefixSpecialAction;
import fitlibrary.traverse.workflow.special.SpecialActionContext;
import fitlibrary.typed.NonGenericTyped;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibrary.xref.CrossReferenceFixture;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

@ShowSelectedActions
public class DoTraverse
extends Traverse
implements FlowEvaluator,
SpecialActionContext {
    private static Logger logger = FitLibraryLogger.getLogger(DoTraverse.class);
    private final PrefixSpecialAction prefixSpecialAction = new PrefixSpecialAction(this);
    protected IDoAutoWrapper doAutoWrapper = new DoAutoWrapper(this);
    protected final DispatchRowInFlow dispatchRowInFlow;
    protected final boolean sequencing;
    public static final String BECOMES_TIMEOUT = "becomes";
    private static final String[] methodsThatAreVisibleAsActions = new String[]{"calculate/0", "start/1", "constraint/0", "failingConstraint/0", "addAs/2"};

    @Override
    public List<String> methodsThatAreVisible() {
        return Arrays.asList(methodsThatAreVisibleAsActions);
    }

    public DoTraverse() {
        this.sequencing = false;
        this.dispatchRowInFlow = new DispatchRowInFlow(this, this.sequencing);
    }

    public DoTraverse(Object sut) {
        super(sut);
        this.sequencing = false;
        this.dispatchRowInFlow = new DispatchRowInFlow(this, this.sequencing);
    }

    public DoTraverse(TypedObject typedObject) {
        super(typedObject);
        this.sequencing = false;
        this.dispatchRowInFlow = new DispatchRowInFlow(this, this.sequencing);
    }

    public DoTraverse(Object sut, boolean sequencing) {
        super(sut);
        this.sequencing = sequencing;
        this.dispatchRowInFlow = new DispatchRowInFlow(this, sequencing);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        return null;
    }

    @Override
    public TypedObject interpretRow(Row row, TestResults testResults) {
        return this.doAutoWrapper.wrap(this.interpretRowBeforeWrapping(row, testResults));
    }

    public final TypedObject interpretRowBeforeWrapping(Row row, TestResults testResults) {
        return this.dispatchRowInFlow.interpretRow(row, testResults);
    }

    @Override
    public Object interpretInFlow(Table table, TestResults testResults) {
        return null;
    }

    @Override
    public ICalledMethodTarget findMethodFromRow(Row row, int from, int extrasCellsOnEnd) throws Exception {
        int upTo = row.size() - extrasCellsOnEnd;
        return PlugBoard.lookupTarget.findMethodByArity(row, from, upTo, !this.dispatchRowInFlow.isDynamicSequencing(), this);
    }

    public ICalledMethodTarget findMethodFromRow222(Row row, int from, int less) throws Exception {
        int extrasCellsOnEnd = less - from - 1;
        int upTo = row.size() - extrasCellsOnEnd;
        return PlugBoard.lookupTarget.findMethodByArity(row, from, upTo, !this.dispatchRowInFlow.isDynamicSequencing(), this);
    }

    protected Object callMethodInRow(Row row, TestResults testResults, boolean catchError, Cell operatorCell) throws Exception {
        return this.findMethodFromRow222(row, 1, 2).invokeForSpecial((Row)row.fromAt(2), testResults, catchError, operatorCell);
    }

    @NullaryAction(tooltip="Treat the rest of the table as a calculate table.")
    public CalculateTraverse calculate() {
        CalculateTraverse traverse = this.getClass() == DoTraverse.class ? new CalculateTraverse(this.getTypedSystemUnderTest()) : new CalculateTraverse(this);
        return traverse;
    }

    public void start(String className) {
        try {
            this.setSystemUnderTest(ClassUtility.newInstance(className));
        }
        catch (Exception e) {
            throw new FitLibraryException("Unknown class: " + className);
        }
    }

    @NullaryAction(tooltip="Treat the rest of the table as a constraint table.")
    public ConstraintTraverse constraint() {
        return new ConstraintTraverse(this);
    }

    @NullaryAction(tooltip="Treat the rest of the table as a failing constraint table.")
    public ConstraintTraverse failingConstraint() {
        ConstraintTraverse traverse = new ConstraintTraverse(this, false);
        return traverse;
    }

    public void becomesTimeout(int timeout) {
        this.global().becomesTimeout(timeout);
    }

    public int becomesTimeout() {
        return this.global().becomesTimeout();
    }

    public int getTimeout(String name) {
        return this.global().getTimeout(name);
    }

    public void putTimeout(String name, int timeout) {
        this.global().putTimeout(name, timeout);
    }

    public void setStopOnError(boolean stopOnError) {
        this.global().setStopOnError(stopOnError);
    }

    public void abandonStorytest() {
        this.global().abandonStorytest();
    }

    public boolean addDynamicVariablesFromFile(String fileName) {
        return this.global().addDynamicVariablesFromFile(fileName);
    }

    public void addDynamicVariablesFromUnicodeFile(String fileName) throws IOException {
        this.global().addDynamicVariablesFromUnicodeFile(fileName);
    }

    public boolean clearDynamicVariables() {
        return this.global().clearDynamicVariables();
    }

    public boolean setSystemPropertyTo(String property, String value) {
        return this.global().setSystemPropertyTo(property, value);
    }

    @Override
    public void setFitVariable(String variableName, Object result) {
        this.global().setFitVariable(variableName, result);
    }

    public Object getSymbolNamed(String fitSymbolName) {
        return this.global().getSymbolNamed(fitSymbolName);
    }

    public boolean sleepFor(int milliseconds) {
        return this.global().sleepFor(milliseconds);
    }

    public void startStopWatch() {
        this.global().startStopWatch();
    }

    public long stopWatch() {
        return this.global().stopWatch();
    }

    public SetVariableTraverse setVariables() {
        return this.global().setVariables();
    }

    public FileHandler file(String fileName) {
        return this.global().file(fileName);
    }

    public CrossReferenceFixture xref(String suiteName) {
        return this.global().xref(suiteName);
    }

    public DefineAction defineAction(String wikiClassName) {
        return this.global().defineAction(wikiClassName);
    }

    public DefineAction defineAction() {
        return this.global().defineAction();
    }

    public void defineActionsSlowlyAt(String pageName) throws Exception {
        this.global().defineActionsSlowlyAt(pageName);
    }

    public void defineActionsAt(String pageName) throws Exception {
        this.global().defineActionsAt(pageName);
    }

    public void defineActionsAtFrom(String pageName, String rootLocation) throws Exception {
        this.global().defineActionsAtFrom(pageName, rootLocation);
    }

    public void clearDefinedActions() {
        this.global().clearDefinedActions();
    }

    public boolean toExpandDefinedActions() {
        return this.global().toExpandDefinedActions();
    }

    public void setExpandDefinedActions(boolean expandDefinedActions) {
        this.global().setExpandDefinedActions(expandDefinedActions);
    }

    public RandomSelectTraverse selectRandomly(String var) {
        return this.global().selectRandomly(var);
    }

    public boolean harvestUsingPatternFrom(String[] vars, String pattern, String text) {
        return this.global().harvestUsingPatternFrom(vars, pattern, text);
    }

    public void recordToFile(String fileName) {
        this.global().recordToFile(fileName);
    }

    public void startLogging(String fileName) {
        this.global().startLogging(fileName);
    }

    @Override
    public void logMessage(String s) {
        this.global().logMessage(s);
    }

    @Override
    public void show(Row row, String text) {
        this.global().show(row, text);
    }

    public void logText(String s) {
        this.global().logText(s);
    }

    @AnAction(wiki="|action...|'''<b>is</b>'''|expected value|", actionType=ActionType.SUFFIX, isCompound=false, tooltip="Check if the result of the action is the expected value.")
    public void is(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseIs");
        }
        ICalledMethodTarget target = this.findMethodFromRow222(row, 0, less);
        Cell expectedCell = (Cell)row.last();
        target.invokeAndCheckForSpecial((Row)row.fromTo(1, row.size() - 2), expectedCell, testResults, row, this.operatorCell(row));
    }

    public void equals(TestResults testResults, Row row) throws Exception {
        this.is(testResults, row);
    }

    @AnAction(wiki="|action...|'''<b>is not</b>'''|unexpected value|", actionType=ActionType.SUFFIX, isCompound=false, tooltip="Check if the result of the action is not the unexpected value.")
    public void isNot(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseIs");
        }
        Cell specialCell = this.operatorCell(row);
        Cell expectedCell = (Cell)row.last();
        try {
            ICalledMethodTarget target = this.findMethodFromRow222(row, 0, less);
            Object result = target.invoke((Row)row.fromTo(1, row.size() - 2), testResults, true);
            target.notResult(expectedCell, result, testResults);
        }
        catch (IgnoredException e) {
        }
        catch (InvocationTargetException e) {
            Throwable embedded = e.getTargetException();
            if (embedded instanceof FitLibraryShowException) {
                specialCell.error(testResults);
                row.error(testResults, e);
            } else {
                expectedCell.exceptionExpected(false, e, testResults);
            }
        }
        catch (Exception e) {
            expectedCell.exceptionExpected(false, e, testResults);
        }
    }

    private Cell operatorCell(Row row) {
        return (Cell)row.at(row.size() - 2);
    }

    @AnAction(wiki="|action...|'''<b>becomes</b>'''|expected value|", actionType=ActionType.SUFFIX, isCompound=false, tooltip="Check if the result of the action eventually becomes the expected value. It fails after the timeout period otherwise.")
    public void becomes(TestResults testResults, Row row) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseMatches");
        }
        ICalledMethodTarget target = this.findMethodFromRow222(row, 0, less);
        Cell expectedCell = (Cell)row.last();
        Row actionPartOfRow = (Row)row.fromTo(1, row.size() - 2);
        long start = System.currentTimeMillis();
        int becomesTimeout = this.getTimeout(BECOMES_TIMEOUT);
        boolean matched = false;
        while (System.currentTimeMillis() - start < (long)becomesTimeout) {
            Object result = target.invokeForSpecial(actionPartOfRow, testResults, false, this.operatorCell(row));
            if (target.getResultParser().matches(expectedCell, result, testResults)) {
                matched = true;
                break;
            }
            try {
                Thread.sleep(Math.min(100, becomesTimeout / 10));
            }
            catch (Exception e) {}
        }
        long delay = System.currentTimeMillis() - start;
        if (!matched && delay > 0L) {
            logger.trace((Object)("becomes failed after " + delay + " milliseconds"));
        }
        target.invokeAndCheckForSpecial(actionPartOfRow, expectedCell, testResults, row, this.operatorCell(row));
    }

    @SimpleAction(wiki="|'''<b>check</b>'''|action...|expected value|", tooltip="Check if the result of the action is the expected value.")
    public TwoStageSpecial check(Row row) throws Exception {
        return this.prefixSpecialAction.check(row);
    }

    @AnAction(wiki="|'''<b>set</b>'''|dynamic variable name|", actionType=ActionType.PREFIX, isCompound=false, tooltip="Set the dynamic variable to the result of the action (or the expression when the action starts with |=|).")
    public TwoStageSpecial set(Row row) throws Exception {
        return this.prefixSpecialAction.set(row);
    }

    @AnAction(wiki="|'''<b>set symbol named</b>'''|symbol name|", actionType=ActionType.PREFIX, isCompound=false, tooltip="Set the Fit symbol to the result of the action.")
    public TwoStageSpecial setSymbolNamed(Row row) throws Exception {
        return this.prefixSpecialAction.setSymbolNamed(row);
    }

    @AnAction(wiki="", actionType=ActionType.PREFIX, isCompound=false, tooltip="Treat the result of the action as a Dot specification, use Dot to create an image, and include it in the report.")
    public void showDot(Row row, TestResults testResults) throws Exception {
        GraphicParser adapter = new GraphicParser(new NonGenericTyped(ObjectDotGraphic.class));
        try {
            Object result = this.callMethodInRow(row, testResults, true, (Cell)row.at(0));
            row.addCell(adapter.show(new ObjectDotGraphic(result)));
        }
        catch (IgnoredException e) {
            // empty catch block
        }
    }

    @AnAction(wiki="", actionType=ActionType.PREFIX, isCompound=false, tooltip="Ignore the rest of the row.")
    public void note(Row row, TestResults testResults) throws Exception {
    }

    public void expectedTestResults(Row row, TestResults testResults) throws Exception {
        if (testResults.matches(row.text(1, this), row.text(3, this), row.text(5, this), row.text(7, this))) {
            testResults.clear();
            ((Cell)row.at(0)).pass(testResults);
        } else {
            String results = testResults.toString();
            testResults.clear();
            ((Cell)row.at(0)).fail(testResults, results, this);
        }
    }

    public Object oo(Row row, TestResults testResults) throws Exception {
        if (row.size() < 3) {
            throw new MissingCellsException("DoTraverseOO");
        }
        String object = row.text(1, this);
        Object className = this.getDynamicVariable(object + ".class");
        if (className == null || "".equals(className)) {
            className = object;
        }
        Row macroRow = (Row)row.fromAt(2);
        TypedObject typedObject = new DefinedActionCaller(object, className.toString(), macroRow, this.getRuntimeContext()).run(row, testResults);
        return typedObject.getSubject();
    }

    public void optionally(Row row, TestResults testResults) throws Exception {
        try {
            Object result = this.callMethodInRow(row, testResults, true, (Cell)row.at(0));
            if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                row.addCell("false").shown();
                this.getRuntimeContext().getDefinedActionCallManager().addShow(row);
            }
        }
        catch (FitLibraryException e) {
            ((Cell)row.at(0)).error(testResults, e);
        }
        catch (Exception e) {
            row.addCell(PlugBoard.exceptionHandling.exceptionMessage(e)).shown();
            this.getRuntimeContext().getDefinedActionCallManager().addShow(row);
        }
        ((Cell)row.at(0)).pass(testResults);
    }

    @AnAction(wiki="|'''<b>add named</b>'''|name|action... or class name|", actionType=ActionType.SELF_FORMAT, isCompound=false, tooltip="Take the result of the action (or an instance of the class) and add it the current scope, with the given name. This is one way of allowing several objects to be used in a storytest at the same time.")
    public void addNamed(Row row, TestResults testResults) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("addNamed");
        }
        TypedObject typedObject = this.interpretRow((Row)row.fromAt(2), testResults);
        this.getRuntimeContext().getTableEvaluator().addNamedObject(row.text(1, this), typedObject, row, testResults);
    }

    @AnAction(wiki="", actionType=ActionType.PREFIX, isCompound=false, tooltip="Take the result of the action (or an instance of the class) and add it as a new global to the scope.")
    public void addGlobal(Row row, TestResults testResults) throws Exception {
        int less = 2;
        if (row.size() < less) {
            throw new MissingCellsException("addGlobal");
        }
        TypedObject typedObject = this.interpretRow((Row)row.fromAt(1), testResults);
        if (typedObject == null || typedObject.getSubject() == null) {
            return;
        }
        if (typedObject.classType() == DoTraverse.class) {
            typedObject = typedObject.getTypedSystemUnderTest();
        }
        typedObject.injectRuntime(this.getRuntimeContext());
        this.getRuntimeContext().getScope().addGlobal(typedObject);
        ((Cell)row.at(0)).pass(testResults);
    }

    @Override
    public FitHandler fitHandler() {
        return DoTraverse.getFitHandler();
    }
}

